<?php

use App\Http\Controllers\AsistenciaController;
use App\Http\Controllers\CalificacionEstudianteController;
use App\Http\Controllers\ConductaController;
use App\Http\Controllers\CursoController;
use App\Http\Controllers\CursoEstudianteController;
use App\Http\Controllers\CursoMaterialController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EstudianteController;
use App\Http\Controllers\ExportExcelsController;
use App\Http\Controllers\GradoController;
use App\Http\Controllers\GradoEstudianteController;
use App\Http\Controllers\NotaController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PromedioController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\VideoController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:web'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.index');
    Route::resource('/users', UsuarioController::class)->except(['create', 'edit']);
    Route::resource('/cursos', CursoController::class)->except(['create', 'edit']);
    Route::resource('/estudiantes', EstudianteController::class)->except(['create', 'edit']);
    Route::resource('/cursos-estudiantes', CursoEstudianteController::class)->except(['create', 'edit']);
    Route::get('/cursos-materiales', [CursoMaterialController::class, 'index'])->name('cursos-materiales.index');
    Route::get('/cursos-materiales/create', [CursoMaterialController::class, 'create'])->name('cursos-materiales.create');
    Route::post('/cursos-materiales', [CursoMaterialController::class, 'store'])->name('cursos-materiales.store');
    Route::get('/cursos-materiales/{id}/edit', [CursoMaterialController::class, 'edit'])->name('cursos-materiales.edit');
    Route::post('/cursos-materiales/{id}', [CursoMaterialController::class, 'update'])->name('cursos-materiales.update');
    Route::patch('/cursos-materiales/{id}', [CursoMaterialController::class, 'update']);
    Route::delete('/cursos-materiales/{id}', [CursoMaterialController::class, 'destroy'])->name('cursos-materiales.destroy');
    Route::get('/promedios/create', [PromedioController::class, 'create'])->name('promedios.create');
    Route::get('/promedios/{id}', [PromedioController::class, 'show'])->name('promedios.show');
    Route::put('/promedios/{id}', [PromedioController::class, 'update'])->name('promedios.update');
    Route::delete('/promedios/{id}', [PromedioController::class, 'destroy'])->name('promedios.destroy');
    Route::post('/notas', [NotaController::class, 'store'])->name('notas.store');
    Route::get('/notas/{id}', [NotaController::class, 'show'])->name('notas.show');
    Route::put('/notas/{id}', [NotaController::class, 'update'])->name('notas.update');
    Route::delete('/notas/{id}', [NotaController::class, 'destroy'])->name('notas.destroy');
    Route::post('/conductas', [ConductaController::class, 'store'])->name('conductas.store');
    Route::get('/conductas/{id}', [ConductaController::class, 'show'])->name('conductas.show');
    Route::put('/conductas/{id}', [ConductaController::class, 'update'])->name('conductas.update');
    Route::delete('/conductas/{id}', [ConductaController::class, 'destroy'])->name('conductas.destroy');
    Route::post('/asistencias', [AsistenciaController::class, 'store'])->name('asistencias.store');
    Route::get('/asistencias/{id}', [AsistenciaController::class, 'show'])->name('asistencias.show');
    Route::put('/asistencias/{id}', [AsistenciaController::class, 'update'])->name('asistencias.update');
    Route::delete('/asistencias/{id}', [AsistenciaController::class, 'destroy'])->name('asistencias.destroy');
    Route::resource('/videos', VideoController::class)->except(['create', 'edit']);
    Route::resource('/grados', GradoController::class)->except(['create', 'edit']);
    Route::resource('/grados-estudiantes', GradoEstudianteController::class)->except(['create', 'edit']);
    Route::get('/export-excel-all-estudiantes', [ExportExcelsController::class, 'exportExcelEstudiantes'])->name('export.all.estudiantes.excel');
});

Route::middleware('auth.estudiante')->group(function () {
    Route::get('/calificaciones', [CalificacionEstudianteController::class, 'index'])
        ->name('calificaciones.index');
    Route::get('/calificaciones/{id}', [CalificacionEstudianteController::class, 'show'])
        ->name('calificaciones.show'); 
});

Route::middleware(['auth.multiguard'])->group(function () {
    Route::get('/promedios', [PromedioController::class, 'index'])->name('promedios.index');
});


require __DIR__ . '/auth-admin.php';
require __DIR__ . '/auth-estudiante.php';
