<?php

use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\ConfirmablePasswordController;
use App\Http\Controllers\Auth\EmailVerificationNotificationController;
use App\Http\Controllers\Auth\EmailVerificationPromptController;
use App\Http\Controllers\Auth\PasswordController;
use App\Http\Controllers\Auth\VerifyEmailController;
use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    Route::get('/', [AuthenticatedSessionController::class, 'create'])
        ->name('login.admin');
    Route::post('/login/admin', [AuthenticatedSessionController::class, 'store'])
        ->name('login.admin.store');
});

Route::middleware(['auth:web'])->group(function () {
    Route::get('/verify-email/admin', EmailVerificationPromptController::class)
        ->name('verification.notice');

    Route::get('/verify-email/admin/{id}/{hash}', VerifyEmailController::class)
        ->middleware(['signed', 'throttle:6,1'])
        ->name('verification.verify');

    Route::post('/email/verification-notification/admin', [EmailVerificationNotificationController::class, 'store'])
        ->middleware('throttle:6,1')
        ->name('verification.send');

    Route::get('/confirm-password/admin', [ConfirmablePasswordController::class, 'show'])
        ->name('password.confirm');

    Route::post('/confirm-password/admin', [ConfirmablePasswordController::class, 'store']);

    Route::put('/password/admin', [PasswordController::class, 'update'])->name('password.update');

    Route::post('/logout/admin', [AuthenticatedSessionController::class, 'destroy'])
        ->name('logout.admin');
});
