<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Estudiantes</title>
</head>

<body>
    <table border="1">
        <thead>
            <tr>
                <th colspan="2" rowspan="2"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Estudiante</th>
                <th rowspan="4"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Cursos
                </th>
                <th colspan="22"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Notas
                </th>
                <th colspan="3" rowspan="2"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Asistencias</th>
                <th colspan="3" rowspan="2"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Conducta</th>
            </tr>

            <tr>
                <th colspan="22"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Resuelve problemas</th>
            </tr>

            <tr>
                <th rowspan="2" style=" background-color: #144A99; color:white; text-align: center;">
                    DNI</th>
                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Datos</th>

                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Fecha</th>
                <th colspan="4"
                    style="border: 1px solid white; border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Cantidad</th>
                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Nivel de Logro</th>

                <th colspan="4"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Regularidad, equivalencia y cambio</th>
                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Nivel de Logro</th>

                <th colspan="4"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Forma, movimiento y localización</th>
                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Nivel de Logro</th>

                <th colspan="4"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Gestión de datos e incertidumbre</th>
                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Nivel de Logro</th>

                <th rowspan="2"
                    style="border: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Promedio del Nivel de Logro</th>
                <th rowspan="2" style=" background-color: #144A99; color:white; text-align: center;">
                    Fecha</th>
                <th rowspan="2" style="background-color: #144A99; color:white; text-align: center;">
                    Tipo</th>
                <th rowspan="2"
                    style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    Hora</th>
                <th rowspan="2" style="background-color: #144A99; color:white; text-align: center;">
                    Fecha</th>
                <th rowspan="2" style="background-color: #144A99; color:white; text-align: center;">
                    Conducta</th>
                <th rowspan="2" style="background-color: #144A99; color:white; text-align: center;">
                    Observación</th>
            </tr>



            <tr>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C1</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C2</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C3</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C4</th>

                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C1</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C2</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C3</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C4</th>

                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C1</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C2</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C3</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C4</th>

                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C1</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C2</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C3</th>
                <th style="border-right: 1px solid white; background-color: #144A99; color:white; text-align: center;">
                    C4</th>
            </tr>

        </thead>
        <tbody>
            @php
                function calcularPromedio(array $notas)
                {
                    $mapa = [
                        'AD' => 20,
                        'A' => 16,
                        'B' => 13,
                        'C' => 10,
                        'D' => 8,
                    ];

                    $suma = 0;
                    $contador = 0;

                    foreach ($notas as $nota) {
                        $notaLimpia = strtoupper(trim($nota));
                        if (isset($mapa[$notaLimpia])) {
                            $suma += $mapa[$notaLimpia];
                            $contador++;
                        }
                    }

                    if ($contador === 0) {
                        return 'Sin datos';
                    }

                    $promedio = $suma / $contador;

                    if ($promedio >= 18) {
                        return 'AD';
                    }
                    if ($promedio >= 15) {
                        return 'A';
                    }
                    if ($promedio >= 12) {
                        return 'B';
                    }
                    if ($promedio >= 9) {
                        return 'C';
                    }
                    return 'D';
                }
            @endphp

            @foreach ($estudiantes as $estudiante)
                <tr>
                    <td style="vertical-align: middle;">{{ $estudiante->dni }}<br></td>
                    <td style="vertical-align: middle;">{{ $estudiante->nombres }} {{ $estudiante->apellido_paterno }}
                        {{ $estudiante->apellido_materno }}<br></td>
                    <td style="vertical-align: middle;">{!! $estudiante->cursos->pluck('nombre')->implode('<br>') !!}<br></td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->fecha }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_cantidad_c1 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_cantidad_c2 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_cantidad_c3 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_cantidad_c4 }}<br>
                        @endforeach
                    </td>
                    <td style="text-align: center; vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            @php
                                $notas = [
                                    $nota->r_p_cantidad_c1,
                                    $nota->r_p_cantidad_c2,
                                    $nota->r_p_cantidad_c3,
                                    $nota->r_p_cantidad_c4,
                                ];
                            @endphp
                            {{ calcularPromedio($notas) }}<br>
                        @endforeach
                    </td>

                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_r_e_cambio_c1 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_r_e_cambio_c2 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_r_e_cambio_c3 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_r_e_cambio_c4 }}<br>
                        @endforeach
                    </td>
                    <td style="text-align: center; vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            @php
                                $notas = [
                                    $nota->r_p_r_e_cambio_c1,
                                    $nota->r_p_r_e_cambio_c2,
                                    $nota->r_p_r_e_cambio_c3,
                                    $nota->r_p_r_e_cambio_c4,
                                ];
                            @endphp
                            {{ calcularPromedio($notas) }}<br>
                        @endforeach
                    </td>


                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_f_m_localizacion_c1 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_f_m_localizacion_c2 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_f_m_localizacion_c3 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_f_m_localizacion_c4 }}<br>
                        @endforeach
                    </td>
                    <td style="text-align: center; vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            @php
                                $notas = [
                                    $nota->r_p_f_m_localizacion_c1,
                                    $nota->r_p_f_m_localizacion_c2,
                                    $nota->r_p_f_m_localizacion_c3,
                                    $nota->r_p_f_m_localizacion_c4,
                                ];
                            @endphp
                            {{ calcularPromedio($notas) }}<br>
                        @endforeach
                    </td>


                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_g_d_incertidumbre_c1 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_g_d_incertidumbre_c2 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_g_d_incertidumbre_c3 }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            {{ $nota->r_p_g_d_incertidumbre_c4 }}<br>
                        @endforeach
                    </td>
                    <td style="text-align: center; vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            @php
                                $notas = [
                                    $nota->r_p_g_d_incertidumbre_c1,
                                    $nota->r_p_g_d_incertidumbre_c2,
                                    $nota->r_p_g_d_incertidumbre_c3,
                                    $nota->r_p_g_d_incertidumbre_c4,
                                ];
                            @endphp
                            {{ calcularPromedio($notas) }}<br>
                        @endforeach
                    </td>

                    <td style="text-align: center; vertical-align: middle;">
                        @foreach ($estudiante->notas as $nota)
                            @php
                                $notas = [
                                    $nota->r_p_cantidad_c1,
                                    $nota->r_p_cantidad_c2,
                                    $nota->r_p_cantidad_c3,
                                    $nota->r_p_cantidad_c4,
                                    $nota->r_p_r_e_cambio_c1,
                                    $nota->r_p_r_e_cambio_c2,
                                    $nota->r_p_r_e_cambio_c3,
                                    $nota->r_p_r_e_cambio_c4,
                                    $nota->r_p_f_m_localizacion_c1,
                                    $nota->r_p_f_m_localizacion_c2,
                                    $nota->r_p_f_m_localizacion_c3,
                                    $nota->r_p_f_m_localizacion_c4,
                                    $nota->r_p_g_d_incertidumbre_c1,
                                    $nota->r_p_g_d_incertidumbre_c2,
                                    $nota->r_p_g_d_incertidumbre_c3,
                                    $nota->r_p_g_d_incertidumbre_c4,
                                ];
                            @endphp
                            {{ calcularPromedio($notas) }}<br>
                        @endforeach
                    </td>

                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->asistencias as $asistencia)
                            {{ $asistencia->fecha }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->asistencias as $asistencia)
                            {{ $asistencia->tipo }}: <br>
                        @endforeach
                    </td>

                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->asistencias as $asistencia)
                            {{ $asistencia->hora }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->conductas as $conducta)
                            {{ $conducta->fecha }}<br>
                        @endforeach
                    </td>
                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->conductas as $conducta)
                            {{ $conducta->conducta }}<br>
                        @endforeach
                    </td>

                    <td style="vertical-align: middle;">
                        @foreach ($estudiante->conductas as $conducta)
                            {{ $conducta->observacion }}<br>
                        @endforeach
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
