import { Curso } from "./curso";

export interface CursoMaterialVideo {
    id: number;
    url_video: string;
    original_name: string;
}

export interface CursoMaterialImagen {
    id: number;
    url_imagen: string;
    original_name: string;
}

export interface CursoMaterialPdf{
    id: number;
    url_pdf: string;
    original_name: string;
}

export interface CursoMaterialRed {
    id: number;
    key: string;
}

export interface CursoMaterial {
    id: number;
    nombre: string;
    curso: Curso;
    id_curso: number;
    cursos_materiales_videos?:CursoMaterialVideo[];
    cursos_materiales_imagenes?:CursoMaterialImagen[];
    cursos_materiales_pdfs?:CursoMaterialPdf[];
    cursos_materiales_redes?: CursoMaterialRed[];
}

export interface DataTableCursoMaterialProps {
    data: CursoMaterial[];
    setCursoMaterial: (cursoMaterial: CursoMaterial) => void;
    openModalCreateOrEdit: () => void;
    openModalDelete: () => void;
}

export interface ModalCursoMaterialProps {
    open: boolean;
    onClose: () => void;
    cursoMaterial?: CursoMaterial;
}
