export function calculadorPromedio(notas: string[]): string {
    const mapa: Record<string, number> = {
      AD: 20,
      A: 16,
      B: 13,
      C: 10,
      D: 8,
    };
  
    let suma = 0;
    let contador = 0;
  
    for (const nota of notas) {
      const notaLimpia = nota.trim().toUpperCase();
      if (mapa[notaLimpia] !== undefined) {
        suma += mapa[notaLimpia];
        contador++;
      }
    }
  
    if (contador === 0) return 'Sin datos';
  
    const promedio = suma / contador;
  
    if (promedio >= 18) return 'AD';
    if (promedio >= 15) return 'A';
    if (promedio >= 12) return 'B';
    if (promedio >= 9) return 'C';
    return 'D';
  }
  