import { create } from "zustand";
import { Video } from "@/types/video";

interface VideoState {
    video: Video | undefined;
    setVideo: (video?: Video) => void;
    openModalCreateOrEditVideo: boolean;
    setOpenModalCreateOrEditVideo: (open: boolean) => void;
    openModalDeleteVideo: boolean;
    setOpenModalDeleteVideo: (open: boolean) => void;
}

export const useVideoStore = create<VideoState>((set) => ({
    video: undefined,
    setVideo: (video) => set({ video }),
    openModalCreateOrEditVideo: false,
    setOpenModalCreateOrEditVideo: (open) =>
        set({ openModalCreateOrEditVideo: open }),
    openModalDeleteVideo: false,
    setOpenModalDeleteVideo: (open) => set({ openModalDeleteVideo: open }),
}));

interface VideosState {
    videos: Video[];
    addVideo: (video: Video) => void;
    addMultipleVideos: (videos: Video[]) => void;
    removeAllVideos: () => void;
    removeVideo: (id: number) => void;
}

export const useVideosStore = create<VideosState>((set) => ({
    videos: [],
    addVideo: (video) => set((state) => ({ videos: [...state.videos, video] })),
    addMultipleVideos: (videos) => set({ videos }),
    removeAllVideos: () => set({ videos: [] }), 
    removeVideo: (id) =>
        set((state) => ({
            videos: state.videos.filter((video) => video.id !== id),
        })),
}));
