import { create } from "zustand";
import { Nota } from "@/types/nota";

interface NotaState {
    nota: Nota | undefined;
    setNota: (nota?: Nota) => void;
    openModalCreateOrEditNota: boolean;
    setOpenModalCreateOrEditNota: (open: boolean) => void;
    openModalDeleteNota: boolean;
    setOpenModalDeleteNota: (open: boolean) => void;
}

export const useNotaStore = create<NotaState>((set) => ({
    nota: undefined,
    setNota: (nota) => set({ nota }),
    openModalCreateOrEditNota: false,
    setOpenModalCreateOrEditNota: (open) =>
        set({ openModalCreateOrEditNota: open }),
    openModalDeleteNota: false,
    setOpenModalDeleteNota: (open) => set({ openModalDeleteNota: open }),
}));
