import { create } from "zustand";
import { Grado } from "@/types/grado";

interface GradoState {
    grado: Grado | undefined;
    setGrado: (grado?: Grado) => void;
    openModalCreateOrEditGrado: boolean;
    setOpenModalCreateOrEditGrado: (open: boolean) => void;
    openModalDeleteGrado: boolean;
    setOpenModalDeleteGrado: (open: boolean) => void;
}

export const useGradoStore = create<GradoState>((set) => ({
    grado: undefined,
    setGrado: (grado) => set({ grado }),
    openModalCreateOrEditGrado: false,
    setOpenModalCreateOrEditGrado: (open) =>
        set({ openModalCreateOrEditGrado: open }),
    openModalDeleteGrado: false,
    setOpenModalDeleteGrado: (open) => set({ openModalDeleteGrado: open }),
}));

interface GradosState {
    grados: Grado[];
    addGrado: (grado: Grado) => void;
    addMultipleGrados: (grados: Grado[]) => void;
    removeAllGrados: () => void;
    removeGrado: (id: number) => void;
}

export const useGradosStore = create<GradosState>((set) => ({
    grados: [],
    addGrado: (grado) => set((state) => ({ grados: [...state.grados, grado] })),
    addMultipleGrados: (grados) => set({ grados }),
    removeAllGrados: () => set({ grados: [] }), 
    removeGrado: (id) =>
        set((state) => ({
            grados: state.grados.filter((grado) => grado.id !== id),
        })),
}));
