import { create } from "zustand";
import { Estudiante } from "@/types/estudiante";

interface EstudianteState {
    estudiante: Estudiante | undefined;
    setEstudiante: (estudiante?: Estudiante) => void;
    openModalCreateOrEditEstudiante: boolean;
    setOpenModalCreateOrEditEstudiante: (open: boolean) => void;
    openModalDeleteEstudiante: boolean;
    setOpenModalDeleteEstudiante: (open: boolean) => void;
}

export const useEstudianteStore = create<EstudianteState>((set) => ({
    estudiante: undefined,
    setEstudiante: (estudiante) => set({ estudiante }),
    openModalCreateOrEditEstudiante: false,
    setOpenModalCreateOrEditEstudiante: (open) => set({ openModalCreateOrEditEstudiante: open }),
    openModalDeleteEstudiante: false,
    setOpenModalDeleteEstudiante: (open) => set({ openModalDeleteEstudiante: open }),
}));
