import { create } from "zustand";
import { Curso } from "@/types/curso";

interface CursoState {
    curso: Curso | undefined;
    setCurso: (curso?: Curso) => void;
    openModalCreateOrEditCurso: boolean;
    setOpenModalCreateOrEditCurso: (open: boolean) => void;
    openModalDeleteCurso: boolean;
    setOpenModalDeleteCurso: (open: boolean) => void;
}

export const useCursoStore = create<CursoState>((set) => ({
    curso: undefined,
    setCurso: (curso) => set({ curso }),
    openModalCreateOrEditCurso: false,
    setOpenModalCreateOrEditCurso: (open) =>
        set({ openModalCreateOrEditCurso: open }),
    openModalDeleteCurso: false,
    setOpenModalDeleteCurso: (open) => set({ openModalDeleteCurso: open }),
}));

interface CursosState {
    cursos: Curso[];
    addCurso: (curso: Curso) => void;
    addMultipleCursos: (cursos: Curso[]) => void;
    removeAllCursos: () => void;
    removeCurso: (id: number) => void;
}

export const useCursosStore = create<CursosState>((set) => ({
    cursos: [],
    addCurso: (curso) => set((state) => ({ cursos: [...state.cursos, curso] })),
    addMultipleCursos: (cursos) => set({ cursos }),
    removeAllCursos: () => set({ cursos: [] }), 
    removeCurso: (id) =>
        set((state) => ({
            cursos: state.cursos.filter((curso) => curso.id !== id),
        })),
}));
