import { create } from "zustand";
import { CursoMaterialVideo } from "@/types/curso-material";

interface CursoMaterialVideoState {
    cursoMaterialVideo: CursoMaterialVideo | undefined;
    setCursoMaterialVideo: (cursoMaterialVideo?: CursoMaterialVideo) => void;
    openModalCreateOrEditCursoMaterialVideo: boolean;
    setOpenModalCreateOrEditCursoMaterialVideo: (open: boolean) => void;
    openModalDeleteCursoMaterialVideo: boolean;
    setOpenModalDeleteCursoMaterialVideo: (open: boolean) => void;
}

export const useCursoMaterialVideoStore = create<CursoMaterialVideoState>((set) => ({
    cursoMaterialVideo: undefined,
    setCursoMaterialVideo: (cursoMaterialVideo) => set({ cursoMaterialVideo }),
    openModalCreateOrEditCursoMaterialVideo: false,
    setOpenModalCreateOrEditCursoMaterialVideo: (open) =>
        set({ openModalCreateOrEditCursoMaterialVideo: open }),
    openModalDeleteCursoMaterialVideo: false,
    setOpenModalDeleteCursoMaterialVideo: (open) => set({ openModalDeleteCursoMaterialVideo: open }),
}));

interface CursosMaterialesVideosState {
    cursosMaterialesVideos: CursoMaterialVideo[];
    addCursoMaterialVideo: (cursoMaterialVideo: CursoMaterialVideo) => void;
    addMultipleCursosMaterialesVideos: (cursosMaterialesVideos: CursoMaterialVideo[]) => void;
    removeAllCursosMaterialesVideos: () => void;
    removeCursoMaterialVideo: (id: number) => void;
}

export const useCursosMaterialesVideosStore = create<CursosMaterialesVideosState>((set) => ({
    cursosMaterialesVideos: [],
    addCursoMaterialVideo: (cursoMaterialVideo) => set((state) => ({ cursosMaterialesVideos: [...state.cursosMaterialesVideos, cursoMaterialVideo] })),
    addMultipleCursosMaterialesVideos: (cursosMaterialesVideos) => set({ cursosMaterialesVideos }),
    removeAllCursosMaterialesVideos: () => set({ cursosMaterialesVideos: [] }), 
    removeCursoMaterialVideo: (id) =>
        set((state) => ({
            cursosMaterialesVideos: state.cursosMaterialesVideos.filter((cursoMaterialVideo) => cursoMaterialVideo.id !== id),
        })),
}));
