import { create } from "zustand";
import { CursoMaterial } from "@/types/curso-material";

interface CursoMaterialState {
    cursoMaterial: CursoMaterial | undefined;
    setCursoMaterial: (cursoMaterial?: CursoMaterial) => void;
    openModalCreateOrEditCursoMaterial: boolean;
    setOpenModalCreateOrEditCursoMaterial: (open: boolean) => void;
    openModalDeleteCursoMaterial: boolean;
    setOpenModalDeleteCursoMaterial: (open: boolean) => void;
}

export const useCursoMaterialStore = create<CursoMaterialState>((set) => ({
    cursoMaterial: undefined,
    setCursoMaterial: (cursoMaterial) => set({ cursoMaterial }),
    openModalCreateOrEditCursoMaterial: false,
    setOpenModalCreateOrEditCursoMaterial: (open) =>
        set({ openModalCreateOrEditCursoMaterial: open }),
    openModalDeleteCursoMaterial: false,
    setOpenModalDeleteCursoMaterial: (open) => set({ openModalDeleteCursoMaterial: open }),
}));

interface CursosMaterialesState {
    cursosMateriales: CursoMaterial[];
    addCursoMaterial: (cursoMaterial: CursoMaterial) => void;
    addMultipleCursosMateriales: (cursosMateriales: CursoMaterial[]) => void;
    removeAllCursosMateriales: () => void;
    removeCursoMaterial: (id: number) => void;
}

export const useCursosStore = create<CursosMaterialesState>((set) => ({
    cursosMateriales: [],
    addCursoMaterial: (cursoMaterial) => set((state) => ({ cursosMateriales: [...state.cursosMateriales, cursoMaterial] })),
    addMultipleCursosMateriales: (cursosMateriales) => set({ cursosMateriales }),
    removeAllCursosMateriales: () => set({ cursosMateriales: [] }), 
    removeCursoMaterial: (id) =>
        set((state) => ({
            cursosMateriales: state.cursosMateriales.filter((cursoMaterial) => cursoMaterial.id !== id),
        })),
}));
