import { create } from "zustand";
import { CursoMaterialPdf } from "@/types/curso-material";

interface CursoMaterialPdfState {
    cursoMaterialPdf: CursoMaterialPdf | undefined;
    setCursoMaterialPdf: (cursoMaterialPdf?: CursoMaterialPdf) => void;
    openModalCreateOrEditCursoMaterialPdf: boolean;
    setOpenModalCreateOrEditCursoMaterialPdf: (open: boolean) => void;
    openModalDeleteCursoMaterialPdf: boolean;
    setOpenModalDeleteCursoMaterialPdf: (open: boolean) => void;
}

export const useCursoMaterialPdfStore = create<CursoMaterialPdfState>(
    (set) => ({
        cursoMaterialPdf: undefined,
        setCursoMaterialPdf: (cursoMaterialPdf) => set({ cursoMaterialPdf }),
        openModalCreateOrEditCursoMaterialPdf: false,
        setOpenModalCreateOrEditCursoMaterialPdf: (open) =>
            set({ openModalCreateOrEditCursoMaterialPdf: open }),
        openModalDeleteCursoMaterialPdf: false,
        setOpenModalDeleteCursoMaterialPdf: (open) =>
            set({ openModalDeleteCursoMaterialPdf: open }),
    })
);

interface CursosMaterialesPdfsState {
    cursosMaterialesPdfs: CursoMaterialPdf[];
    addCursoMaterialPdf: (cursoMaterialPdf: CursoMaterialPdf) => void;
    addMultipleCursosMaterialesPdfs: (
        cursosMaterialesPdfs: CursoMaterialPdf[]
    ) => void;
    removeAllCursosMaterialesPdfs: () => void;
    removeCursoMaterialPdf: (id: number) => void;
}

export const useCursosMaterialesPdfsStore = create<CursosMaterialesPdfsState>(
    (set) => ({
        cursosMaterialesPdfs: [],
        addCursoMaterialPdf: (cursoMaterialPdf) =>
            set((state) => ({
                cursosMaterialesPdfs: [
                    ...state.cursosMaterialesPdfs,
                    cursoMaterialPdf,
                ],
            })),
        addMultipleCursosMaterialesPdfs: (cursosMaterialesPdfs) =>
            set({ cursosMaterialesPdfs }),
        removeAllCursosMaterialesPdfs: () => set({ cursosMaterialesPdfs: [] }),
        removeCursoMaterialPdf: (id) =>
            set((state) => ({
                cursosMaterialesPdfs: state.cursosMaterialesPdfs.filter(
                    (cursoMaterialPdf) => cursoMaterialPdf.id !== id
                ),
            })),
    })
);
