import { create } from "zustand";
import { CursoMaterialImagen } from "@/types/curso-material";

interface CursoMaterialImagenState {
    cursoMaterialImagen: CursoMaterialImagen | undefined;
    setCursoMaterialImagen: (cursoMaterialImagen?: CursoMaterialImagen) => void;
    openModalCreateOrEditCursoMaterialImagen: boolean;
    setOpenModalCreateOrEditCursoMaterialImagen: (open: boolean) => void;
    openModalDeleteCursoMaterialImagen: boolean;
    setOpenModalDeleteCursoMaterialImagen: (open: boolean) => void;
}

export const useCursoMaterialImagenStore = create<CursoMaterialImagenState>((set) => ({
    cursoMaterialImagen: undefined,
    setCursoMaterialImagen: (cursoMaterialImagen) => set({ cursoMaterialImagen }),
    openModalCreateOrEditCursoMaterialImagen: false,
    setOpenModalCreateOrEditCursoMaterialImagen: (open) =>
        set({ openModalCreateOrEditCursoMaterialImagen: open }),
    openModalDeleteCursoMaterialImagen: false,
    setOpenModalDeleteCursoMaterialImagen: (open) => set({ openModalDeleteCursoMaterialImagen: open }),
}));

interface CursosMaterialesImagenesState {
    cursosMaterialesImagenes: CursoMaterialImagen[];
    addCursoMaterialImagen: (cursoMaterialImagen: CursoMaterialImagen) => void;
    addMultipleCursosMaterialesImagenes: (cursosMaterialesImagenes: CursoMaterialImagen[]) => void;
    removeAllCursosMaterialesImagenes: () => void;
    removeCursoMaterialImagen: (id: number) => void;
}

export const useCursosMaterialesImagenesStore = create<CursosMaterialesImagenesState>((set) => ({
    cursosMaterialesImagenes: [],
    addCursoMaterialImagen: (cursoMaterialImagen) => set((state) => ({ cursosMaterialesImagenes: [...state.cursosMaterialesImagenes, cursoMaterialImagen] })),
    addMultipleCursosMaterialesImagenes: (cursosMaterialesImagenes) => set({ cursosMaterialesImagenes }),
    removeAllCursosMaterialesImagenes: () => set({ cursosMaterialesImagenes: [] }), 
    removeCursoMaterialImagen: (id) =>
        set((state) => ({
            cursosMaterialesImagenes: state.cursosMaterialesImagenes.filter((cursoMaterialImagen) => cursoMaterialImagen.id !== id),
        })),
}));
