import { create } from "zustand";
import { Conducta } from "@/types/conducta";

interface ConductaState {
    conducta: Conducta | undefined;
    setConducta: (conducta?: Conducta) => void;
    openModalCreateOrEditConducta: boolean;
    setOpenModalCreateOrEditConducta: (open: boolean) => void;
    openModalDeleteConducta: boolean;
    setOpenModalDeleteConducta: (open: boolean) => void;
}

export const useConductaStore = create<ConductaState>((set) => ({
    conducta: undefined,
    setConducta: (conducta) => set({ conducta }),
    openModalCreateOrEditConducta: false,
    setOpenModalCreateOrEditConducta: (open) =>
        set({ openModalCreateOrEditConducta: open }),
    openModalDeleteConducta: false,
    setOpenModalDeleteConducta: (open) =>
        set({ openModalDeleteConducta: open }),
}));
