import { create } from "zustand";
import { Asistencia } from "@/types/asistencia";

interface AsistenciaState {
    asistencia: Asistencia | undefined;
    setAsistencia: (asistencia?: Asistencia) => void;
    openModalCreateOrEditAsistencia: boolean;
    setOpenModalCreateOrEditAsistencia: (open: boolean) => void;
    openModalDeleteAsistencia: boolean;
    setOpenModalDeleteAsistencia: (open: boolean) => void;
}

export const useAsistenciaStore = create<AsistenciaState>((set) => ({
    asistencia: undefined,
    setAsistencia: (asistencia) => set({ asistencia }),
    openModalCreateOrEditAsistencia: false,
    setOpenModalCreateOrEditAsistencia: (open) => set({ openModalCreateOrEditAsistencia: open }),
    openModalDeleteAsistencia: false,
    setOpenModalDeleteAsistencia: (open) => set({ openModalDeleteAsistencia: open }),
}));
