import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Video } from "@/types/video";
import { Pencil, Trash2 } from "lucide-react";
import { useVideoStore } from "@/Store/useVideoStore";

export default function DataTable({ data }: { data: Video[] }) {
    const { setVideo, setOpenModalCreateOrEditVideo, setOpenModalDeleteVideo } =
        useVideoStore();

    const handleEdit = (video: Video) => {
        setVideo(video);
        setOpenModalCreateOrEditVideo(true);
    };

    const handleDelete = (video: Video) => {
        setVideo(video);
        setOpenModalDeleteVideo(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Key</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((video) => (
                        <TableRow key={video.id}>
                            <TableCell>{video.key}</TableCell>
                            <TableCell className="flex gap-4">
                                <Button onClick={() => handleEdit(video)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(video)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={2} className="text-center">
                            No se encontraron videos.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
