import { Button } from "@/Components/ui/button";
import { Video } from "@/types/video";
import { CirclePlus, Pencil } from "lucide-react";

export const ButtonModalCreate = ({
    openModalCreate,
}: {
    video?: Video;
    openModalCreate: () => void;
}) => {
    return (
        <Button onClick={openModalCreate}>
            Crear
            <CirclePlus />
        </Button>
    );
};

export const ButtonModalCreateOrEdit = ({
    openModalEdit,
}: {
    openModalEdit: () => void;
}) => {
    return (
        <Button onClick={openModalEdit}>
            <Pencil />
        </Button>
    );
};
