import { usePage, router } from "@inertiajs/react";
import LayoutPrivate from "@/Layouts/Private/layout";
import SearchBar from "@/Components/SearchBar";
import DataTable from "./components/DataTable";
import Pagination from "@/Components/Pagination";
import { PageProps } from "@/types/param";
import { Card } from "@/Components/ui/card";
import { Video } from "@/types/video";
import { ModalCreateOrEdit } from "./components/ModalCreateOrEdit";
import { Button } from "@/Components/ui/button";
import { CirclePlus } from "lucide-react";
import { useVideoStore } from "@/Store/useVideoStore";
import { useState } from "react";
import { ModalDeleteVideo } from "./components/ModalDelete";

export default function Index() {
    const { auth, videos, filters } = usePage<PageProps<Video>>().props;
    const [search, setSearch] = useState<string>(filters.search || "");
    const [perPage, setPerPage] = useState<number>(filters.per_page || 10);

    const {
        setVideo,
        openModalCreateOrEditVideo,
        openModalDeleteVideo,
        setOpenModalCreateOrEditVideo,
    } = useVideoStore();

    const handlePerPageChange = (value: string) => {
        const perPageValue = Number(value);
        setPerPage(perPageValue);
        router.get(route("videos.index"), { search, per_page: perPageValue });
    };

    const handleSearch = (value: string) => {
        setSearch(value);
        router.get(
            route("videos.index"),
            { search: value, perPage },
            { preserveState: true }
        );
    };

    return (
        <LayoutPrivate user={auth.user} header={"Videos"}>
            <div className="w-full max-w-4xl">
                <Card className="pt-4 px-4 flex gap-4">
                    <SearchBar
                     keyName="Video"
                        className={"flex-1"}
                        search={search}
                        perPage={perPage}
                        onSearch={handleSearch}
                        onPerPageChange={handlePerPageChange}
                    />
                    <Button
                        onClick={() => {
                            setOpenModalCreateOrEditVideo(true);
                            setVideo(undefined);
                        }}
                    >
                        Crear <CirclePlus />
                    </Button>
                </Card>
                <Card className="mt-8 px-4 pb-4">
                    <DataTable data={videos.data} />
                    <Pagination
                        currentPage={videos.current_page}
                        lastPage={videos.last_page}
                        prevPageUrl={videos.prev_page_url}
                        nextPageUrl={videos.next_page_url}
                        search={search}
                        perPage={perPage}
                    />
                </Card>
            </div>
            {openModalCreateOrEditVideo && <ModalCreateOrEdit />}
            {openModalDeleteVideo && <ModalDeleteVideo />}
        </LayoutPrivate>
    );
}
