import {
    AlertDialog,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from "@/Components/ui/alert-dialog";
import { Button } from "@/Components/ui/button";
import { useNotaStore } from "@/Store/useNotaStore";
import { useForm } from "@inertiajs/react";
import { toast } from "sonner";
import { Page } from "@inertiajs/core";

export function ModalDeleteNota() {
    const { nota, openModalDeleteNota, setOpenModalDeleteNota } =
        useNotaStore();
    const { delete: destroy, processing } = useForm();

    const handleDelete = () => {
        if (!nota?.id) return;

        destroy(route("notas.destroy", nota.id), {
            preserveScroll: true,
            onSuccess: (response: Page<{ status?: { success?: string } }>) => {
                const successMessage =
                    response.props?.status?.success ??
                    "Nota eliminado correctamente.";
                toast.success(successMessage);
                setOpenModalDeleteNota(false);
            },
            onError: (response: {
                props?: { status?: { error?: string } };
            }) => {
                const errorMessage =
                    response?.props?.status?.error || "Error en el formulario.";
                toast.error(errorMessage);
            },
        });
    };

    return (
        <AlertDialog
            open={openModalDeleteNota}
            onOpenChange={() => setOpenModalDeleteNota(false)}
        >
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>Eliminar Nota</AlertDialogTitle>
                    <AlertDialogDescription>
                        ¿Estás seguro de que deseas eliminar la nota "
                        {nota?.fecha}"? Esta acción no se puede deshacer.
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <footer className="flex justify-around gap-4 mt-4">
                    <Button
                        type="button"
                        onClick={() => setOpenModalDeleteNota(false)}
                        variant="secondary"
                    >
                        Cancelar
                    </Button>
                    <Button
                        type="button"
                        onClick={handleDelete}
                        disabled={processing}
                        variant="destructive"
                    >
                        Eliminar
                    </Button>
                </footer>
            </AlertDialogContent>
        </AlertDialog>
    );
}
