import {
    AlertDialog,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from "@/Components/ui/alert-dialog";
import { Button } from "@/Components/ui/button";
import { Input } from "@/Components/ui/input";
import { Label } from "@/Components/ui/label";
import { useForm, usePage } from "@inertiajs/react";
import { FormEventHandler, useId, useState } from "react";
import { useNotaStore } from "@/Store/useNotaStore";
import { toast } from "sonner";
import { Page } from "@inertiajs/core";
import { validateInputText } from "@/Utils/validations";
import { format } from "date-fns";
import { es } from "date-fns/locale";
import { CalendarIcon } from "lucide-react";
import { Calendar } from "@/Components/ui/calendar";
import { cn } from "@/lib/utils";
import { PageProps } from "@/types/param";
import { Estudiante } from "@/types/estudiante";
import { ImageUploader } from "@/Components/ImageUploader";
import {
    Select,
    SelectContent,
    SelectGroup,
    SelectItem,
    SelectLabel,
    SelectTrigger,
    SelectValue,
} from "@/Components/ui/select";

interface Form {
    id: number | null;
    fecha: string;
    r_p_cantidad_c1: string;
    r_p_cantidad_c2: string;
    r_p_cantidad_c3: string;
    r_p_cantidad_c4: string;
    r_p_r_e_cambio_c1: string;
    r_p_r_e_cambio_c2: string;
    r_p_r_e_cambio_c3: string;
    r_p_r_e_cambio_c4: string;
    r_p_f_m_localizacion_c1: string;
    r_p_f_m_localizacion_c2: string;
    r_p_f_m_localizacion_c3: string;
    r_p_f_m_localizacion_c4: string;
    r_p_g_d_incertidumbre_c1: string;
    r_p_g_d_incertidumbre_c2: string;
    r_p_g_d_incertidumbre_c3: string;
    r_p_g_d_incertidumbre_c4: string;
    url_imagen: File | null;
    id_estudiante: number | undefined;
}
export function ModalCreateOrEditNota() {
    const idNota = useId();
    const RPCantidadC1 = useId();
    const RPCantidadC2 = useId();
    const RPCantidadC3 = useId();
    const RPCantidadC4 = useId();
    const RPRECambioC1 = useId();
    const RPRECambioC2 = useId();
    const RPRECambioC3 = useId();
    const RPRECambioC4 = useId();
    const RPFMLocalizacionC1 = useId();
    const RPFMLocalizacionC2 = useId();
    const RPFMLocalizacionC3 = useId();
    const RPFMLocalizacionC4 = useId();
    const RPGDIncertidumbreC1 = useId();
    const RPGDIncertidumbreC2 = useId();
    const RPGDIncertidumbreC3 = useId();
    const RPGDIncertidumbreC4 = useId();

    const idFecha = useId();

    const { nota, openModalCreateOrEditNota, setOpenModalCreateOrEditNota } =
        useNotaStore();

    const { estudiante } = usePage<PageProps<Estudiante>>().props;

    const { data, setData, post, put, reset, clearErrors, processing, errors } =
        useForm<Form>({
            id: nota?.id ?? null,
            fecha: nota?.fecha || "",
            r_p_cantidad_c1: nota?.r_p_cantidad_c1 || "",
            r_p_cantidad_c2: nota?.r_p_cantidad_c2 || "",
            r_p_cantidad_c3: nota?.r_p_cantidad_c3 || "",
            r_p_cantidad_c4: nota?.r_p_cantidad_c4 || "",
            r_p_r_e_cambio_c1: nota?.r_p_r_e_cambio_c1 || "",
            r_p_r_e_cambio_c2: nota?.r_p_r_e_cambio_c2 || "",
            r_p_r_e_cambio_c3: nota?.r_p_r_e_cambio_c3 || "",
            r_p_r_e_cambio_c4: nota?.r_p_r_e_cambio_c4 || "",
            r_p_f_m_localizacion_c1: nota?.r_p_f_m_localizacion_c1 || "",
            r_p_f_m_localizacion_c2: nota?.r_p_f_m_localizacion_c2 || "",
            r_p_f_m_localizacion_c3: nota?.r_p_f_m_localizacion_c3 || "",
            r_p_f_m_localizacion_c4: nota?.r_p_f_m_localizacion_c4 || "",
            r_p_g_d_incertidumbre_c1: nota?.r_p_g_d_incertidumbre_c1 || "",
            r_p_g_d_incertidumbre_c2: nota?.r_p_g_d_incertidumbre_c2 || "",
            r_p_g_d_incertidumbre_c3: nota?.r_p_g_d_incertidumbre_c3 || "",
            r_p_g_d_incertidumbre_c4: nota?.r_p_g_d_incertidumbre_c4 || "",
            id_estudiante: nota?.id_estudiante || estudiante?.id || undefined,
            url_imagen: null,
        });

    const submit: FormEventHandler = (e) => {
        e.preventDefault();

        const options = {
            preserveScroll: true,
            onSuccess: (response: Page<{ status?: { success?: string } }>) => {
                reset();
                const successMessage =
                    response.props.status?.success ||
                    "Operación realizada con éxito.";
                toast.success(successMessage);
                setOpenModalCreateOrEditNota(false);
            },
            onError: (errors: Record<string, string> | undefined) => {
                if (errors) {
                    Object.entries(errors).forEach(([field, message]) => {
                        toast.error(`${field}: ${message}`);
                    });
                } else {
                    toast.error("Error en el formulario.");
                }
            },
        };

        if (data.id) {
            put(route("notas.update", { id: data.id }), options);
        } else {
            post(route("notas.store"), options);
        }

        clearErrors();
    };

    const [selectedDate, setSelectedDate] = useState<Date | undefined>(
        data.fecha ? new Date(data.fecha) : undefined
    );

    return (
        <AlertDialog
            open={openModalCreateOrEditNota}
            onOpenChange={() => setOpenModalCreateOrEditNota(false)}
        >
            <AlertDialogContent className="max-w-6xl w-full">
                <AlertDialogHeader>
                    <AlertDialogTitle>
                        {nota?.id ? "Editar" : "Crear"} Nota
                    </AlertDialogTitle>
                    <AlertDialogDescription>
                        {nota?.id
                            ? "Modifica los datos de la nota y guarda los cambios."
                            : "Ingresa los datos para registrar una nueva nota."}
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <form
                    onSubmit={submit}
                    className="relative overflow-y-auto max-h-[80vh] "
                >
                    <div className="mt-8 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <Label htmlFor={RPCantidadC1}>
                                Resuelve problemas de cantidad C1
                            </Label>
                            <Select
                                value={data.r_p_cantidad_c1 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_cantidad_c1",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPCantidadC1}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_cantidad_c1 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPCantidadC1}
                                >
                                    {errors.r_p_cantidad_c1}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPCantidadC2}>
                                Resuelve problemas de cantidad C2
                            </Label>
                            <Select
                                value={data.r_p_cantidad_c2 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_cantidad_c2",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPCantidadC2}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_cantidad_c2 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPCantidadC2}
                                >
                                    {errors.r_p_cantidad_c2}
                                </Label>
                            )}
                        </div>
                        <div>
                            <Label htmlFor={RPCantidadC3}>
                                Resuelve problemas de cantidad C3
                            </Label>
                            <Select
                                value={data.r_p_cantidad_c3 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_cantidad_c3",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPCantidadC3}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_cantidad_c3 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPCantidadC3}
                                >
                                    {errors.r_p_cantidad_c3}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPCantidadC4}>
                                Resuelve problemas de cantidad C4
                            </Label>
                            <Select
                                value={data.r_p_cantidad_c4 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_cantidad_c4",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPCantidadC4}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_cantidad_c4 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPCantidadC4}
                                >
                                    {errors.r_p_cantidad_c4}
                                </Label>
                            )}
                        </div>
                    </div>

                    {/* as */}
                    <div className="mt-8 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <Label htmlFor={RPRECambioC1}>
                                Resuelve problemas de regularidad, equivalencia
                                y cambio C1
                            </Label>
                            <Select
                                value={data.r_p_r_e_cambio_c1 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_r_e_cambio_c1",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPRECambioC1}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_r_e_cambio_c1 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPRECambioC1}
                                >
                                    {errors.r_p_r_e_cambio_c1}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPRECambioC2}>
                                Resuelve problemas de regularidad, equivalencia
                                y cambio C2
                            </Label>
                            <Select
                                value={data.r_p_r_e_cambio_c2 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_r_e_cambio_c2",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPRECambioC2}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_r_e_cambio_c2 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPRECambioC2}
                                >
                                    {errors.r_p_r_e_cambio_c2}
                                </Label>
                            )}
                        </div>
                        <div>
                            <Label htmlFor={RPRECambioC3}>
                                Resuelve problemas de regularidad, equivalencia
                                y cambio C3
                            </Label>
                            <Select
                                value={data.r_p_r_e_cambio_c3 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_r_e_cambio_c3",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPRECambioC3}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_r_e_cambio_c3 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPRECambioC3}
                                >
                                    {errors.r_p_r_e_cambio_c3}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPRECambioC4}>
                                Resuelve problemas de regularidad, equivalencia
                                y cambio C4
                            </Label>
                            <Select
                                value={data.r_p_r_e_cambio_c4 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_r_e_cambio_c4",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPRECambioC4}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_r_e_cambio_c4 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPRECambioC4}
                                >
                                    {errors.r_p_r_e_cambio_c4}
                                </Label>
                            )}
                        </div>
                    </div>
                    {/* as */}
                    <div className="mt-8 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <Label htmlFor={RPFMLocalizacionC1}>
                                Resuelve problemas de forma, movimiento y
                                localización C1
                            </Label>
                            <Select
                                value={data.r_p_f_m_localizacion_c1 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_f_m_localizacion_c1",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPFMLocalizacionC1}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem
                                            value="none"
                                        >
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_f_m_localizacion_c1 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPFMLocalizacionC1}
                                >
                                    {errors.r_p_f_m_localizacion_c1}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPFMLocalizacionC2}>
                                Resuelve problemas de forma, movimiento y
                                localización C2
                            </Label>
                            <Select
                                value={data.r_p_f_m_localizacion_c2 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_f_m_localizacion_c2",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPFMLocalizacionC2}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none" className="">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_f_m_localizacion_c2 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPFMLocalizacionC2}
                                >
                                    {errors.r_p_f_m_localizacion_c2}
                                </Label>
                            )}
                        </div>
                        <div>
                            <Label htmlFor={RPFMLocalizacionC3}>
                                Resuelve problemas de forma, movimiento y
                                localización C3
                            </Label>
                            <Select
                                value={data.r_p_f_m_localizacion_c3 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_f_m_localizacion_c3",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPFMLocalizacionC3}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none" className="">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_f_m_localizacion_c3 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPFMLocalizacionC3}
                                >
                                    {errors.r_p_f_m_localizacion_c3}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPFMLocalizacionC4}>
                                Resuelve problemas de forma, movimiento y
                                localización C4
                            </Label>
                            <Select
                                value={data.r_p_f_m_localizacion_c4 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_f_m_localizacion_c4",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPFMLocalizacionC4}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none" className="">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_f_m_localizacion_c4 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPFMLocalizacionC4}
                                >
                                    {errors.r_p_f_m_localizacion_c4}
                                </Label>
                            )}
                        </div>
                    </div>
                    {/* ne */}
                    <div className="mt-8 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div>
                            <Label htmlFor={RPGDIncertidumbreC1}>
                                Resuelve problemas de gestión de datos e
                                incertidumbre C1
                            </Label>
                            <Select
                                value={data.r_p_g_d_incertidumbre_c1 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_g_d_incertidumbre_c1",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPGDIncertidumbreC1}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_g_d_incertidumbre_c1 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPGDIncertidumbreC1}
                                >
                                    {errors.r_p_g_d_incertidumbre_c1}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPGDIncertidumbreC2}>
                                Resuelve problemas de gestión de datos e
                                incertidumbre C2
                            </Label>
                            <Select
                                value={data.r_p_g_d_incertidumbre_c2 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_g_d_incertidumbre_c2",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPGDIncertidumbreC2}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_g_d_incertidumbre_c2 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPGDIncertidumbreC2}
                                >
                                    {errors.r_p_g_d_incertidumbre_c2}
                                </Label>
                            )}
                        </div>
                        <div>
                            <Label htmlFor={RPGDIncertidumbreC3}>
                                Resuelve problemas de gestión de datos e
                                incertidumbre C3
                            </Label>
                            <Select
                                value={data.r_p_g_d_incertidumbre_c3 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_g_d_incertidumbre_c3",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPGDIncertidumbreC3}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_g_d_incertidumbre_c3 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPGDIncertidumbreC3}
                                >
                                    {errors.r_p_g_d_incertidumbre_c3}
                                </Label>
                            )}
                        </div>

                        <div>
                            <Label htmlFor={RPGDIncertidumbreC4}>
                                Resuelve problemas de gestión de datos e
                                incertidumbre C4
                            </Label>
                            <Select
                                value={data.r_p_g_d_incertidumbre_c4 || "none"}
                                onValueChange={(value) =>
                                    setData(
                                        "r_p_g_d_incertidumbre_c4",
                                        value === "none" ? "" : value
                                    )
                                }
                            >
                                <SelectTrigger
                                    id={RPGDIncertidumbreC4}
                                    className="w-full"
                                >
                                    <SelectValue placeholder="Seleccionar una Calificación" />
                                </SelectTrigger>
                                <SelectContent>
                                    <SelectGroup>
                                        <SelectItem value="none">
                                            Ninguno
                                        </SelectItem>
                                        <SelectItem value="AD">AD</SelectItem>
                                        <SelectItem value="A">A</SelectItem>
                                        <SelectItem value="B">B</SelectItem>
                                        <SelectItem value="C">C</SelectItem>
                                        <SelectItem value="D">D</SelectItem>
                                    </SelectGroup>
                                </SelectContent>
                            </Select>
                            {errors.r_p_g_d_incertidumbre_c4 && (
                                <Label
                                    className="text-destructive"
                                    htmlFor={RPGDIncertidumbreC4}
                                >
                                    {errors.r_p_g_d_incertidumbre_c4}
                                </Label>
                            )}
                        </div>
                    </div>
                    <Label htmlFor={idFecha}>Fecha</Label>
                    <div className=" mt-4">
                        <Button
                            variant="outline"
                            type="button"
                            className={cn(
                                "w-full pl-3 text-left font-normal",
                                !selectedDate && "text-muted-foreground"
                            )}
                        >
                            {selectedDate ? (
                                format(selectedDate, "PPP", { locale: es })
                            ) : (
                                <span>Selecciona una fecha</span>
                            )}
                            <CalendarIcon className="ml-auto h-4 w-4 opacity-50" />
                        </Button>
                        <div className=" flex justify-center">
                            <Calendar
                                mode="single"
                                selected={selectedDate}
                                onSelect={(date) => {
                                    setSelectedDate(date);
                                    if (date) {
                                        setData(
                                            "fecha",
                                            date.toISOString().split("T")[0]
                                        );
                                    }
                                }}
                                disabled={(date) =>
                                    date > new Date() ||
                                    date < new Date("1900-01-01")
                                }
                                initialFocus
                            />
                        </div>
                    </div>

                    <ImageUploader
                        setData={setData}
                        fallbackUrl={nota?.url_imagen}
                    />

                    {errors.url_imagen && (
                        <Label className="text-destructive">
                            {errors.url_imagen}
                        </Label>
                    )}

                    <footer className="flex justify-around gap-4 mt-4">
                        <Button
                            type="button"
                            onClick={() => setOpenModalCreateOrEditNota(false)}
                            variant="secondary"
                        >
                            Cancelar
                        </Button>
                        <Button type="submit" disabled={processing}>
                            Guardar
                        </Button>
                    </footer>
                </form>
            </AlertDialogContent>
        </AlertDialog>
    );
}
