import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Nota } from "@/types/nota";
import { Pencil, Trash2 } from "lucide-react";
import { useNotaStore } from "@/Store/useNotaStore";
import { calculadorPromedio } from "@/Utils/calculador-promedio";

export default function DataTableNota({ data }: { data: Nota[] }) {
    const { setNota, setOpenModalCreateOrEditNota, setOpenModalDeleteNota } =
        useNotaStore();

    const handleEdit = (nota: Nota) => {
        setNota(nota);
        setOpenModalCreateOrEditNota(true);
    };

    const handleDelete = (nota: Nota) => {
        setNota(nota);
        setOpenModalDeleteNota(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead colSpan={21} className="text-center border">
                        Notas
                    </TableHead>
                    <TableHead rowSpan={4} className="border text-center">
                        Fecha
                    </TableHead>
                    <TableHead rowSpan={4} className="border text-center">
                        Fotografía
                    </TableHead>
                    <TableHead rowSpan={4} className="border text-center">
                        Acciones
                    </TableHead>
                </TableRow>
                <TableRow>
                    <TableHead colSpan={21} className="border text-center">
                        Resuelve problemas
                    </TableHead>
                </TableRow>
                <TableRow>
                    <TableHead colSpan={4} className="border text-center">
                        Cantidad
                    </TableHead>
                    <TableHead
                        rowSpan={3}
                        className="border text-center bg-secondary"
                    >
                        Nivel de Logro
                    </TableHead>
                    <TableHead colSpan={4} className="border text-center">
                        Regularidad, equivalencia y cambio
                    </TableHead>
                    <TableHead
                        rowSpan={3}
                        className="border text-center bg-secondary"
                    >
                        Nivel de Logro
                    </TableHead>
                    <TableHead colSpan={4} className="border text-center">
                        Forma, movimiento y localización
                    </TableHead>
                    <TableHead
                        rowSpan={3}
                        className="border text-center bg-secondary"
                    >
                        Nivel de Logro
                    </TableHead>
                    <TableHead colSpan={4} className="border text-center">
                        Gestión de datos e incertidumbre
                    </TableHead>
                    <TableHead
                        rowSpan={3}
                        className="border text-center bg-secondary"
                    >
                        Nivel de Logro
                    </TableHead>
                    <TableHead
                        rowSpan={3}
                        className="border text-center bg-primary text-background"
                    >
                        Promedio del Nivel de Logro
                    </TableHead>
                </TableRow>
                <TableRow>
                    <TableHead className="border">C1</TableHead>
                    <TableHead className="border">C2</TableHead>
                    <TableHead className="border">C3</TableHead>
                    <TableHead className="border">C4</TableHead>

                    <TableHead className="border">C1</TableHead>
                    <TableHead className="border">C2</TableHead>
                    <TableHead className="border">C3</TableHead>
                    <TableHead className="border">C4</TableHead>

                    <TableHead className="border">C1</TableHead>
                    <TableHead className="border">C2</TableHead>
                    <TableHead className="border">C3</TableHead>
                    <TableHead className="border">C4</TableHead>

                    <TableHead className="border">C1</TableHead>
                    <TableHead className="border">C2</TableHead>
                    <TableHead className="border">C3</TableHead>
                    <TableHead className="border">C4</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((nota) => (
                        <TableRow key={nota.id}>
                            <TableCell className="border text-center">
                                {nota?.r_p_cantidad_c1}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_cantidad_c2}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_cantidad_c3}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_cantidad_c4}
                            </TableCell>
                            <TableCell className="border bg-secondary text-center">
                                {calculadorPromedio([
                                    nota?.r_p_cantidad_c1 ?? "",
                                    nota?.r_p_cantidad_c2 ?? "",
                                    nota?.r_p_cantidad_c3 ?? "",
                                    nota?.r_p_cantidad_c4 ?? "",
                                ])}
                            </TableCell>

                            <TableCell className="border text-center">
                                {nota?.r_p_r_e_cambio_c1}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_r_e_cambio_c2}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_r_e_cambio_c3}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_r_e_cambio_c4}
                            </TableCell>
                            <TableCell className="border bg-secondary text-center">
                                {calculadorPromedio([
                                    nota?.r_p_r_e_cambio_c1 ?? "",
                                    nota?.r_p_r_e_cambio_c2 ?? "",
                                    nota?.r_p_r_e_cambio_c3 ?? "",
                                    nota?.r_p_r_e_cambio_c4 ?? "",
                                ])}
                            </TableCell>

                            <TableCell className="border text-center">
                                {nota?.r_p_f_m_localizacion_c1}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_f_m_localizacion_c2}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_f_m_localizacion_c3}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_f_m_localizacion_c4}
                            </TableCell>
                            <TableCell className="border bg-secondary text-center">
                                {calculadorPromedio([
                                    nota?.r_p_f_m_localizacion_c1 ?? "",
                                    nota?.r_p_f_m_localizacion_c2 ?? "",
                                    nota?.r_p_f_m_localizacion_c3 ?? "",
                                    nota?.r_p_f_m_localizacion_c4 ?? "",
                                ])}
                            </TableCell>

                            <TableCell className="border text-center">
                                {nota?.r_p_g_d_incertidumbre_c1}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_g_d_incertidumbre_c2}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_g_d_incertidumbre_c3}
                            </TableCell>
                            <TableCell className="border text-center">
                                {nota?.r_p_g_d_incertidumbre_c4}
                            </TableCell>
                            <TableCell className="border bg-secondary text-center">
                                {calculadorPromedio([
                                    nota?.r_p_g_d_incertidumbre_c1 ?? "",
                                    nota?.r_p_g_d_incertidumbre_c2 ?? "",
                                    nota?.r_p_g_d_incertidumbre_c3 ?? "",
                                    nota?.r_p_g_d_incertidumbre_c4 ?? "",
                                ])}
                            </TableCell>

                            <TableCell className="border bg-primary text-background text-center">
                                {calculadorPromedio([
                                    nota?.r_p_cantidad_c1 ?? "",
                                    nota?.r_p_cantidad_c2 ?? "",
                                    nota?.r_p_cantidad_c3 ?? "",
                                    nota?.r_p_cantidad_c4 ?? "",

                                    nota?.r_p_r_e_cambio_c1 ?? "",
                                    nota?.r_p_r_e_cambio_c2 ?? "",
                                    nota?.r_p_r_e_cambio_c3 ?? "",
                                    nota?.r_p_r_e_cambio_c4 ?? "",

                                    nota?.r_p_f_m_localizacion_c1 ?? "",
                                    nota?.r_p_f_m_localizacion_c2 ?? "",
                                    nota?.r_p_f_m_localizacion_c3 ?? "",
                                    nota?.r_p_f_m_localizacion_c4 ?? "",

                                    nota?.r_p_g_d_incertidumbre_c1 ?? "",
                                    nota?.r_p_g_d_incertidumbre_c2 ?? "",
                                    nota?.r_p_g_d_incertidumbre_c3 ?? "",
                                    nota?.r_p_g_d_incertidumbre_c4 ?? "",
                                ])}
                            </TableCell>

                            <TableCell className="border">
                                {nota.fecha}
                            </TableCell>

                            <TableCell className="border">
                                <div className="max-h-12 max-w-12">
                                    {nota.url_imagen && (
                                        <img
                                            src={nota.url_imagen}
                                            alt={"Imagen de la nota"}
                                            className="mt-2 rounded-lg shadow-md w-12 h-12 object-cover"
                                        />
                                    )}
                                </div>
                            </TableCell>
                            <TableCell className="flex gap-4 border">
                                <Button onClick={() => handleEdit(nota)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(nota)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={24} className="text-center">
                            No se encontraron notas.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
