import { Button } from "@/Components/ui/button";
import { Nota } from "@/types/nota";
import { CirclePlus, Pencil } from "lucide-react";

export const ButtonModalCreateNota = ({
    openModalCreateNota,
}: {
    nota?: Nota;
    openModalCreateNota: () => void;
}) => {
    return (
        <Button onClick={openModalCreateNota}>
            Crear
            <CirclePlus />
        </Button>
    );
};

export const ButtonModalCreateOrEditNota = ({
    openModalEditNota,
}: {
    openModalEditNota: () => void;
}) => {
    return (
        <Button onClick={openModalEditNota}>
            <Pencil />
        </Button>
    );
};
