import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Conducta } from "@/types/conducta";
import { Pencil, Trash2 } from "lucide-react";
import { useConductaStore } from "@/Store/useConductaStore";

export default function DataTableConducta({ data }: { data: Conducta[] }) {
    const { setConducta, setOpenModalCreateOrEditConducta, setOpenModalDeleteConducta } =
        useConductaStore();

    const handleEdit = (conducta: Conducta) => {
        setConducta(conducta);
        setOpenModalCreateOrEditConducta(true);
    };

    const handleDelete = (conducta: Conducta) => {
        setConducta(conducta);
        setOpenModalDeleteConducta(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Conducta</TableHead>
                    <TableHead>Observación</TableHead>
                    <TableHead>Fecha</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((conducta) => (
                        <TableRow key={conducta.id}>
                            <TableCell>{conducta.conducta}</TableCell>
                            <TableCell>{conducta.observacion}</TableCell>
                            <TableCell>{conducta.fecha}</TableCell>
                            
                            <TableCell className="flex gap-4">
                                <Button onClick={() => handleEdit(conducta)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(conducta)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={4} className="text-center">
                            No se encontraron conductas.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
