import { Button } from "@/Components/ui/button";
import { FC } from "react";

interface PaginationProps {
    currentPage: number;
    lastPage: number;
    prevPageUrl: string | null;
    nextPageUrl: string | null;
    search: string;
    perPage: number;
    onPageChange: (newPage: number) => void;
}

export const Pagination: FC<PaginationProps> = ({
    currentPage,
    lastPage,
    prevPageUrl,
    nextPageUrl,
    onPageChange,
}) => {
    return (
        <div className="flex justify-between items-center">
            <div className="flex gap-2">
                <Button
                    disabled={!prevPageUrl}
                    onClick={() => onPageChange(currentPage - 1)}
                    className="px-4 py-2 "
                >
                    Anterior
                </Button>
                <span className="flex items-center">
                    Página {currentPage} de {lastPage}
                </span>
                <Button
                    disabled={!nextPageUrl}
                    onClick={() => onPageChange(currentPage + 1)}
                    className="px-4 py-2 0"
                >
                    Siguiente
                </Button>
            </div>
        </div>
    );
};
