import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Asistencia } from "@/types/asistencia";
import { Pencil, Trash2 } from "lucide-react";
import { useAsistenciaStore } from "@/Store/useAsistenciaStore";

export default function DataTableAsistencia({ data }: { data: Asistencia[] }) {
    const { setAsistencia, setOpenModalCreateOrEditAsistencia, setOpenModalDeleteAsistencia } =
        useAsistenciaStore();

    const handleEdit = (asistencia: Asistencia) => {
        setAsistencia(asistencia);
        setOpenModalCreateOrEditAsistencia(true);
    };

    const handleDelete = (asistencia: Asistencia) => {
        setAsistencia(asistencia);
        setOpenModalDeleteAsistencia(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Asistencia</TableHead>
                    <TableHead>Fecha</TableHead>
                    <TableHead>Hora</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((asistencia) => (
                        <TableRow key={asistencia.id}>
                            <TableCell>{asistencia.tipo}</TableCell>
                            <TableCell>{asistencia.fecha}</TableCell>
                            <TableCell>{asistencia.hora}</TableCell>
                            
                            <TableCell className="flex gap-4">
                                <Button onClick={() => handleEdit(asistencia)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(asistencia)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={4} className="text-center">
                            No se encontraron asistencias.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
