import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Grado } from "@/types/grado";
import { Pencil, Trash2 } from "lucide-react";
import { useGradoStore } from "@/Store/useGradoStore";

export default function DataTable({ data }: { data: Grado[] }) {
    const { setGrado, setOpenModalCreateOrEditGrado, setOpenModalDeleteGrado } =
        useGradoStore();

    const handleEdit = (grado: Grado) => {
        setGrado(grado);
        setOpenModalCreateOrEditGrado(true);
    };

    const handleDelete = (grado: Grado) => {
        setGrado(grado);
        setOpenModalDeleteGrado(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Nombre</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((grado) => (
                        <TableRow key={grado.id}>
                            <TableCell>{grado.nombre}</TableCell>
                            <TableCell className="flex gap-4">
                                <Button onClick={() => handleEdit(grado)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(grado)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={2} className="text-center">
                            No se encontraron grados.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
