import { Button } from "@/Components/ui/button";
import { Grado } from "@/types/grado";
import { CirclePlus, Pencil } from "lucide-react";

export const ButtonModalCreate = ({
    openModalCreate,
}: {
    grado?: Grado;
    openModalCreate: () => void;
}) => {
    return (
        <Button onClick={openModalCreate}>
            Crear
            <CirclePlus />
        </Button>
    );
};

export const ButtonModalCreateOrEdit = ({
    openModalEdit,
}: {
    openModalEdit: () => void;
}) => {
    return (
        <Button onClick={openModalEdit}>
            <Pencil />
        </Button>
    );
};
