import { usePage, router } from "@inertiajs/react";
import LayoutPrivate from "@/Layouts/Private/layout";
import SearchBar from "@/Components/SearchBar";
import DataTable from "./components/DataTable";
import Pagination from "@/Components/Pagination";
import { PageProps } from "@/types/param";
import { Card } from "@/Components/ui/card";
import { Grado } from "@/types/grado";
import { ModalCreateOrEdit } from "./components/ModalCreateOrEdit";
import { Button } from "@/Components/ui/button";
import { CirclePlus } from "lucide-react";
import { useGradoStore } from "@/Store/useGradoStore";
import { useState } from "react";
import { ModalDeleteGrado } from "./components/ModalDelete";

export default function Index() {
    const { auth, grados, filters } = usePage<PageProps<Grado>>().props;
    const [search, setSearch] = useState<string>(filters.search || "");
    const [perPage, setPerPage] = useState<number>(filters.per_page || 10);

    const {
        setGrado,
        openModalCreateOrEditGrado,
        openModalDeleteGrado,
        setOpenModalCreateOrEditGrado,
    } = useGradoStore();

    const handlePerPageChange = (value: string) => {
        const perPageValue = Number(value);
        setPerPage(perPageValue);
        router.get(route("grados.index"), { search, per_page: perPageValue });
    };

    const handleSearch = (value: string) => {
        setSearch(value);
        router.get(
            route("grados.index"),
            { search: value, perPage },
            { preserveState: true }
        );
    };

    return (
        <LayoutPrivate user={auth.user} header={"Grado Escolar"}>
            <div className="w-full max-w-4xl">
                <Card className="pt-4 px-4 flex gap-4">
                    <SearchBar
                     keyName="Grado Escolar"
                        className={"flex-1"}
                        search={search}
                        perPage={perPage}
                        onSearch={handleSearch}
                        onPerPageChange={handlePerPageChange}
                    />
                    <Button
                        onClick={() => {
                            setOpenModalCreateOrEditGrado(true);
                            setGrado(undefined);
                        }}
                    >
                        Crear <CirclePlus />
                    </Button>
                </Card>
                <Card className="mt-8 px-4 pb-4">
                    <DataTable data={grados.data} />
                    <Pagination
                        currentPage={grados.current_page}
                        lastPage={grados.last_page}
                        prevPageUrl={grados.prev_page_url}
                        nextPageUrl={grados.next_page_url}
                        search={search}
                        perPage={perPage}
                    />
                </Card>
            </div>
            {openModalCreateOrEditGrado && <ModalCreateOrEdit />}
            {openModalDeleteGrado && <ModalDeleteGrado />}
        </LayoutPrivate>
    );
}
