import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Estudiante } from "@/types/estudiante";
import { ChartColumnIncreasing, Pencil, Trash2 } from "lucide-react";
import { useEstudianteStore } from "@/Store/useEstudianteStore";
import { Link } from "@inertiajs/react";

export default function DataTable({ data }: { data: Estudiante[] }) {
    const {
        setEstudiante,
        setOpenModalCreateOrEditEstudiante,
        setOpenModalDeleteEstudiante,
    } = useEstudianteStore();

    const handleEdit = (estudiante: Estudiante) => {
        setEstudiante(estudiante);
        setOpenModalCreateOrEditEstudiante(true);
    };

    const handleDelete = (estudiante: Estudiante) => {
        setEstudiante(estudiante);
        setOpenModalDeleteEstudiante(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>DNI</TableHead>
                    <TableHead>Datos</TableHead>
                    <TableHead>Celular Estudiante</TableHead>
                    <TableHead>Celular Apoderado</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((estudiante) => (
                        <TableRow key={estudiante.id}>
                            <TableCell>{estudiante.dni}</TableCell>
                            <TableCell>
                                {estudiante.nombres}{" "}
                                {estudiante.apellido_paterno}{" "}
                                {estudiante.apellido_materno}
                            </TableCell>
                            <TableCell>{estudiante.celular}</TableCell>
                            <TableCell>
                                {estudiante.celular_apoderado}
                            </TableCell>
                            <TableCell className="flex gap-4">

                                <Link href={route('promedios.index', { id_estudiante: estudiante.id })} method="get">
                                    <Button variant={"outline"}>
                                        <ChartColumnIncreasing />
                                    </Button>
                                </Link>

                                <Button onClick={() => handleEdit(estudiante)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(estudiante)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={5} className="text-center">
                            No se encontraron estudiantes.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
