import { Button } from "@/Components/ui/button";
import { Estudiante } from "@/types/estudiante";
import { CirclePlus, Pencil } from "lucide-react";

export const ButtonModalCreate = ({
    openModalCreate,
}: {
    estudiante?: Estudiante;
    openModalCreate: () => void;
}) => {
    return (
        <Button onClick={openModalCreate}>
            Crear
            <CirclePlus />
        </Button>
    );
};

export const ButtonModalCreateOrEdit = ({
    openModalEdit,
}: {
    openModalEdit: () => void;
}) => {
    return (
        <Button onClick={openModalEdit}>
            <Pencil />
        </Button>
    );
};
