import { usePage, router } from "@inertiajs/react";
import LayoutPrivate from "@/Layouts/Private/layout";
import SearchBar from "@/Components/SearchBar";
import DataTable from "./components/DataTable";
import Pagination from "@/Components/Pagination";
import { PageProps } from "@/types/param";
import { Card } from "@/Components/ui/card";
import { Estudiante } from "@/types/estudiante";
import { ModalCreateOrEdit } from "./components/ModalCreateOrEdit";
import { Button } from "@/Components/ui/button";
import { CirclePlus, FileX2 } from "lucide-react";
import { useEstudianteStore } from "@/Store/useEstudianteStore";
import { useState } from "react";
import { ModalDeleteEstudiante } from "./components/ModalDelete";

export default function Index() {
    const { auth, estudiantes, filters } =
        usePage<PageProps<Estudiante>>().props;
    const [search, setSearch] = useState<string>(filters.search || "");
    const [perPage, setPerPage] = useState<number>(filters.per_page || 10);

    const {
        setEstudiante,
        openModalCreateOrEditEstudiante,
        openModalDeleteEstudiante,
        setOpenModalCreateOrEditEstudiante,
    } = useEstudianteStore();

    const handlePerPageChange = (value: string) => {
        const perPageValue = Number(value);
        setPerPage(perPageValue);
        router.get(route("estudiantes.index"), {
            search,
            per_page: perPageValue,
        });
    };

    const handleSearch = (value: string) => {
        setSearch(value);
        router.get(
            route("estudiantes.index"),
            { search: value, perPage },
            { preserveState: true }
        );
    };

    return (
        <LayoutPrivate user={auth.user} header={"Estudiantes"}>
            <div className="w-full max-w-4xl">
                <Card className="pt-4 px-4 flex gap-4">
                    <SearchBar
                        keyName="Estudiante"
                        className={"flex-1"}
                        search={search}
                        perPage={perPage}
                        onSearch={handleSearch}
                        onPerPageChange={handlePerPageChange}
                    />
                    <a
                        href={"/export-excel-all-estudiantes"}
                        rel="noreferrer noopener"
                        target="_blank"
                        className="flex gap-4 items-center justify-center h-10 border rounded-md px-4 hover:pointer"
                    >
                        Exportar <FileX2 />
                    </a>

                    <Button
                        onClick={() => {
                            setOpenModalCreateOrEditEstudiante(true);
                            setEstudiante(undefined);
                        }}
                    >
                        Crear <CirclePlus />
                    </Button>
                </Card>
                <Card className="mt-8 px-4 pb-4">
                    <DataTable data={estudiantes.data} />
                    <Pagination
                        currentPage={estudiantes.current_page}
                        lastPage={estudiantes.last_page}
                        prevPageUrl={estudiantes.prev_page_url}
                        nextPageUrl={estudiantes.next_page_url}
                        search={search}
                        perPage={perPage}
                    />
                </Card>
            </div>
            {openModalCreateOrEditEstudiante && <ModalCreateOrEdit />}
            {openModalDeleteEstudiante && <ModalDeleteEstudiante />}
        </LayoutPrivate>
    );
}
