import LayoutPrivate from "@/Layouts/Private/layout";
import {
    Card,
    CardContent,
    CardDescription,
    CardHeader,
    CardTitle,
} from "@/Components/ui/card";
import { usePage } from "@inertiajs/react";
import { PageProps } from "@/types/param";

interface DashboardProps {
    cantidad_estudiantes: number;
    cantidad_cursos: number;
}

export default function Dashboard() {
    const { auth, cantidad_estudiantes, cantidad_cursos } =
        usePage<PageProps<DashboardProps>>().props;

    return (
        <LayoutPrivate user={auth.user} header="Dashboard">
            <div className="w-full grid grid-cols-1 md:grid-cols-2 gap-4">
                <Card>
                    <CardHeader>
                        <CardTitle>Estudiantes</CardTitle>
                        <CardDescription>
                        Cantidad actual de estudiantes
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <p className="text-xl font-bold text-center">
                            {cantidad_estudiantes}
                        </p>
                    </CardContent>
                </Card>

                <Card>
                    <CardHeader>
                        <CardTitle>Cursos</CardTitle>
                        <CardDescription>Total de cursos disponibles</CardDescription>
                    </CardHeader>
                    <CardContent>
                        <p className="text-xl font-bold text-center">{cantidad_cursos}</p>
                    </CardContent>
                </Card>
            </div>
        </LayoutPrivate>
    );
}
