import {
    AlertDialog,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from "@/Components/ui/alert-dialog";
import { Button } from "@/Components/ui/button";
import { useCursoMaterialStore } from "@/Store/useCursoMaterialStore";
import { useForm } from "@inertiajs/react";
import { toast } from "sonner";
import { Page } from "@inertiajs/core";

export function ModalDeleteCursoMaterial() {
    const { cursoMaterial, openModalDeleteCursoMaterial, setOpenModalDeleteCursoMaterial } =
        useCursoMaterialStore();
    const { delete: destroy, processing } = useForm();

    const handleDelete = () => {
        if (!cursoMaterial?.id) return;

        destroy(route("cursos-materiales.destroy", cursoMaterial.id), {
            preserveScroll: true,
            onSuccess: (response: Page<{ status?: { success?: string } }>) => {
                const successMessage =
                    response.props?.status?.success ??
                    "Sesión de Estudio eliminado correctamente.";
                toast.success(successMessage);
                setOpenModalDeleteCursoMaterial(false);
            },
            onError: (response: {
                props?: { status?: { error?: string } };
            }) => {
                const errorMessage =
                    response?.props?.status?.error || "Error en el formulario.";
                toast.error(errorMessage);
            },
        });
    };

    return (
        <AlertDialog
            open={openModalDeleteCursoMaterial}
            onOpenChange={() => setOpenModalDeleteCursoMaterial(false)}
        >
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>Eliminar Sesión de Estudio</AlertDialogTitle>
                    <AlertDialogDescription>
                        ¿Estás seguro de que deseas eliminar la sesión de estudio "
                        {cursoMaterial?.nombre}"? Esta acción no se puede deshacer.
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <footer className="flex justify-around gap-4 mt-4">
                    <Button
                        type="button"
                        onClick={() => setOpenModalDeleteCursoMaterial(false)}
                        variant="secondary"
                    >
                        Cancelar
                    </Button>
                    <Button
                        type="button"
                        onClick={handleDelete}
                        disabled={processing}
                        variant="destructive"
                    >
                        Eliminar
                    </Button>
                </footer>
            </AlertDialogContent>
        </AlertDialog>
    );
}
