import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import {
    CursoMaterial,
} from "@/types/curso-material";
import { Pencil, Trash2 } from "lucide-react";
import { useCursoMaterialStore } from "@/Store/useCursoMaterialStore";
import { Link } from "@inertiajs/react";

export default function DataTable({ data }: { data: CursoMaterial[] }) {
    const {
        setCursoMaterial,
        setOpenModalDeleteCursoMaterial,
    } = useCursoMaterialStore();


    const handleDelete = (cursoMaterial: CursoMaterial) => {
        setCursoMaterial(cursoMaterial);
        setOpenModalDeleteCursoMaterial(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Nombre</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((cursoMaterial) => (
                        <TableRow key={crypto.randomUUID()}>
                            <TableCell>{cursoMaterial.nombre}</TableCell>
                            <TableCell className="flex gap-4">
                                <Link href={route("cursos-materiales.edit", cursoMaterial.id )}>
                                    <Button type="button">
                                        <Pencil />
                                    </Button>
                                </Link>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(cursoMaterial)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={2} className="text-center">
                            No se encontraron sessiones de Estudio.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
