import { Button } from "@/Components/ui/button";
import { CursoMaterial } from "@/types/curso-material";
import { CirclePlus, Pencil } from "lucide-react";

export const ButtonModalCreate = ({
    openModalCreate,
}: {
    cursoMaterial?: CursoMaterial;
    openModalCreate: () => void;
}) => {
    return (
        <Button onClick={openModalCreate}>
            Crear
            <CirclePlus />
        </Button>
    );
};

export const ButtonModalCreateOrEdit = ({
    openModalEdit,
}: {
    openModalEdit: () => void;
}) => {
    return (
        <Button onClick={openModalEdit}>
            <Pencil />
        </Button>
    );
};
