import {
    AlertDialog,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from "@/Components/ui/alert-dialog";
import { Button } from "@/Components/ui/button";
import { useCursoStore } from "@/Store/useCursoStore";
import { useForm } from "@inertiajs/react";
import { toast } from "sonner";
import { Page } from "@inertiajs/core";

export function ModalDeleteCurso() {
    const { curso, openModalDeleteCurso, setOpenModalDeleteCurso } =
        useCursoStore();
    const { delete: destroy, processing } = useForm();

    const handleDelete = () => {
        if (!curso?.id) return;

        destroy(route("cursos.destroy", curso.id), {
            preserveScroll: true,
            onSuccess: (response: Page<{ status?: { success?: string } }>) => {
                const successMessage =
                    response.props?.status?.success ??
                    "Curso eliminado correctamente.";
                toast.success(successMessage);
                setOpenModalDeleteCurso(false);
            },
            onError: (response: {
                props?: { status?: { error?: string } };
            }) => {
                const errorMessage =
                    response?.props?.status?.error || "Error en el formulario.";
                toast.error(errorMessage);
            },
        });
    };

    return (
        <AlertDialog
            open={openModalDeleteCurso}
            onOpenChange={() => setOpenModalDeleteCurso(false)}
        >
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>Eliminar Curso</AlertDialogTitle>
                    <AlertDialogDescription>
                        ¿Estás seguro de que deseas eliminar el curso "
                        {curso?.nombre}"? Esta acción no se puede deshacer.
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <footer className="flex justify-around gap-4 mt-4">
                    <Button
                        type="button"
                        onClick={() => setOpenModalDeleteCurso(false)}
                        variant="secondary"
                    >
                        Cancelar
                    </Button>
                    <Button
                        type="button"
                        onClick={handleDelete}
                        disabled={processing}
                        variant="destructive"
                    >
                        Eliminar
                    </Button>
                </footer>
            </AlertDialogContent>
        </AlertDialog>
    );
}
