import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Curso } from "@/types/curso";
import { Pencil, Trash2 } from "lucide-react";
import { useCursoStore } from "@/Store/useCursoStore";

export default function DataTable({ data }: { data: Curso[] }) {
    const { setCurso, setOpenModalCreateOrEditCurso, setOpenModalDeleteCurso } =
        useCursoStore();

    const handleEdit = (curso: Curso) => {
        setCurso(curso);
        setOpenModalCreateOrEditCurso(true);
    };

    const handleDelete = (curso: Curso) => {
        setCurso(curso);
        setOpenModalDeleteCurso(true);
    };

    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Nombre</TableHead>
                    <TableHead className="w-32">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((curso) => (
                        <TableRow key={curso.id}>
                            <TableCell>{curso.nombre}</TableCell>
                            <TableCell className="flex gap-4">
                                <Button onClick={() => handleEdit(curso)}>
                                    <Pencil />
                                </Button>
                                <Button
                                    variant="destructive"
                                    onClick={() => handleDelete(curso)}
                                >
                                    <Trash2 />
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={2} className="text-center">
                            No se encontraron cursos.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
