import { Button } from "@/Components/ui/button";
import { Curso } from "@/types/curso";
import { CirclePlus, Pencil } from "lucide-react";

export const ButtonModalCreate = ({
    openModalCreate,
}: {
    curso?: Curso;
    openModalCreate: () => void;
}) => {
    return (
        <Button onClick={openModalCreate}>
            Crear
            <CirclePlus />
        </Button>
    );
};

export const ButtonModalCreateOrEdit = ({
    openModalEdit,
}: {
    openModalEdit: () => void;
}) => {
    return (
        <Button onClick={openModalEdit}>
            <Pencil />
        </Button>
    );
};
