import { usePage, router } from "@inertiajs/react";
import LayoutPrivate from "@/Layouts/Private/layout";
import SearchBar from "@/Components/SearchBar";
import DataTable from "./components/DataTable";
import Pagination from "@/Components/Pagination";
import { PageProps } from "@/types/param";
import { Card } from "@/Components/ui/card";
import { Curso } from "@/types/curso";
import { ModalCreateOrEdit } from "./components/ModalCreateOrEdit";
import { Button } from "@/Components/ui/button";
import { CirclePlus } from "lucide-react";
import { useCursoStore } from "@/Store/useCursoStore";
import { useState } from "react";
import { ModalDeleteCurso } from "./components/ModalDelete";

export default function Index() {
    const { auth, cursos, filters } = usePage<PageProps<Curso>>().props;
    const [search, setSearch] = useState<string>(filters.search || "");
    const [perPage, setPerPage] = useState<number>(filters.per_page || 10);

    const {
        setCurso,
        openModalCreateOrEditCurso,
        openModalDeleteCurso,
        setOpenModalCreateOrEditCurso,
    } = useCursoStore();

    const handlePerPageChange = (value: string) => {
        const perPageValue = Number(value);
        setPerPage(perPageValue);
        router.get(route("cursos.index"), { search, per_page: perPageValue });
    };

    const handleSearch = (value: string) => {
        setSearch(value);
        router.get(
            route("cursos.index"),
            { search: value, perPage },
            { preserveState: true }
        );
    };

    return (
        <LayoutPrivate user={auth.user} header={"Cursos"}>
            <div className="w-full max-w-4xl">
                <Card className="pt-4 px-4 flex gap-4">
                    <SearchBar
                     keyName="Curso"
                        className={"flex-1"}
                        search={search}
                        perPage={perPage}
                        onSearch={handleSearch}
                        onPerPageChange={handlePerPageChange}
                    />
                    <Button
                        onClick={() => {
                            setOpenModalCreateOrEditCurso(true);
                            setCurso(undefined);
                        }}
                    >
                        Crear <CirclePlus />
                    </Button>
                </Card>
                <Card className="mt-8 px-4 pb-4">
                    <DataTable data={cursos.data} />
                    <Pagination
                        currentPage={cursos.current_page}
                        lastPage={cursos.last_page}
                        prevPageUrl={cursos.prev_page_url}
                        nextPageUrl={cursos.next_page_url}
                        search={search}
                        perPage={perPage}
                    />
                </Card>
            </div>
            {openModalCreateOrEditCurso && <ModalCreateOrEdit />}
            {openModalDeleteCurso && <ModalDeleteCurso />}
        </LayoutPrivate>
    );
}
