import { Label } from "@/Components/ui/label";
import Sidebar from "./Components/Sidebar";
import {
    CursoMaterial,
    CursoMaterialImagen,
    CursoMaterialPdf,
    CursoMaterialRed,
    CursoMaterialVideo,
} from "@/types/curso-material";
import { Estudiante } from "@/types/estudiante";
import { PageProps } from "@/types/param";
import { Link, usePage } from "@inertiajs/react";
import { Button } from "@/Components/ui/button";

interface SesionEstudio {
    estudiante: Estudiante;
    curso_material: CursoMaterial;
}

export default function Show() {
    const { estudiante, curso_material } =
        usePage<PageProps<SesionEstudio>>().props;
    return (
        <Sidebar estudiante={estudiante}>
            <div className="fixed z-50 top-5 left-20 sm:left-44 md:left-64">
                <Link href={route("calificaciones.index")} className="">
                    Volver
                </Link>
            </div>

            <div className=" mt-20 px-4 sm:px-8 lg:px-16 space-y-12">

                {curso_material.cursos_materiales_redes.length > 0 && (
                    <div className="container mx-auto">
                        <Label className="text-lg font-semibold px-4">
                            Videos TikTok
                        </Label>

                        <div className=" flex gap-4 overflow-x-auto pb-4 scrollbar-thin scrollbar-track-transparent">
                            <div className="flex space-x-4">
                                {curso_material.cursos_materiales_redes.map((video: CursoMaterialRed) => (
                                    <div
                                        key={video.id}
                                        className="flex-shrink-0 w-full sm:w-[350px] aspect-[9/16] rounded-lg overflow-hidden border shadow-lg hover:shadow-md transition-shadow"
                                    >
                                        <iframe
                                            src={`https://www.tiktok.com/embed/${video.key}?reels=0&no_ads=1&autoplay=1&hide_related=1&showinfo=0&controls=0&loop=1&muted=1`}
                                            title={`TikTok Video ${video.key}`}
                                            className="w-full h-full"
                                            frameBorder="0"
                                            allowFullScreen
                                            loading="lazy"
                                            sandbox="allow-scripts allow-same-origin"
                                        />
                                    </div>
                                ))}
                            </div>
                        </div>
                    </div>
                )}


                {curso_material.cursos_materiales_videos.length > 0 && (
                    <div>
                        <Label className="block text-xl font-semibold mb-4 text-center">
                            Videos
                        </Label>
                        <div className="grid grid-cols-1 sm:grid-cols-2">
                            {curso_material.cursos_materiales_videos.map(
                                (video: CursoMaterialVideo) => (
                                    <video
                                        key={video.id}
                                        src={
                                            video.url_video?.startsWith("blob:")
                                                ? video.url_video
                                                : "/" + video.url_video
                                        }
                                        className="w-full h-auto rounded-lg border shadow-lg"
                                        controls
                                    />
                                )
                            )}
                        </div>
                    </div>
                )}

                {curso_material.cursos_materiales_videos.length > 0 && (
                    <div>
                        <Label className="block text-xl font-semibold mb-4 text-center">
                            Videos
                        </Label>
                        <div className="grid grid-cols-1 sm:grid-cols-2">
                            {curso_material.cursos_materiales_videos.map(
                                (video: CursoMaterialVideo) => (
                                    <video
                                        key={video.id}
                                        src={
                                            video.url_video?.startsWith("blob:")
                                                ? video.url_video
                                                : "/" + video.url_video
                                        }
                                        className="w-full h-auto rounded-lg border shadow-lg"
                                        controls
                                    />
                                )
                            )}
                        </div>
                    </div>
                )}

                {curso_material.cursos_materiales_imagenes.length > 0 && (
                    <div>
                        <Label className="block text-xl font-semibold mb-4 text-center">
                            Imágenes
                        </Label>
                        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            {curso_material.cursos_materiales_imagenes.map(
                                (imagen: CursoMaterialImagen) => (
                                    <img
                                        key={imagen.id}
                                        src={
                                            imagen.url_imagen?.startsWith(
                                                "blob:"
                                            )
                                                ? imagen.url_imagen
                                                : "/" + imagen.url_imagen
                                        }
                                        className="w-full max-h-96 object-contain rounded-lg border shadow-md"
                                        alt="Imagen de sesión de estudio"
                                    />
                                )
                            )}
                        </div>
                    </div>
                )}

                {curso_material.cursos_materiales_pdfs.length > 0 && (
                    <div>
                        <Label className="block text-xl font-semibold mb-4 text-center">
                            PDFs
                        </Label>
                        <div className="grid grid-cols-1  gap-6">
                            {curso_material.cursos_materiales_pdfs.map(
                                (pdf: CursoMaterialPdf) => (
                                    <iframe
                                        key={pdf.id}
                                        src={
                                            pdf.url_pdf?.startsWith("blob:")
                                                ? pdf.url_pdf
                                                : "/" + pdf.url_pdf
                                        }
                                        className="w-full h-[500px] rounded-lg border shadow-md"
                                        title={pdf.original_name}
                                    />
                                )
                            )}
                        </div>
                    </div>
                )}
            </div>
        </Sidebar>
    );
}
