import { useState } from "react";
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";

import { Nota } from "@/types/nota";
import {
    Dialog,
    DialogContent,
    DialogDescription,
    DialogTitle,
    DialogTrigger,
} from "@/Components/ui/dialog";
import { calculadorPromedio } from "@/Utils/calculador-promedio";

export default function DataTableNota({ data }: { data: Nota[] }) {
    // Estado para manejar la visibilidad del dialog y la imagen seleccionada
    const [selectedImage, setSelectedImage] = useState<string | null>(null);

    // Función para abrir el dialog con la imagen seleccionada
    const handleImageClick = (imageUrl: string) => {
        setSelectedImage(imageUrl);
    };

    return (
        <Table>
           <TableHeader>
                <TableRow>
                    <TableHead colSpan={5} className="text-center">Promedio de Notas</TableHead>
                    <TableHead rowSpan={3} className="">Fecha</TableHead>
                    <TableHead rowSpan={3} className="">Fotografía</TableHead>
                </TableRow>
                <TableRow>
                    <TableHead  colSpan={4}>Promedio del Logro, Resuelve problemas de:</TableHead>
                    <TableHead rowSpan={2}>Promedio total de Logros</TableHead>
                </TableRow>
                <TableRow>
                    <TableHead>Cantidad</TableHead>
                    <TableHead>Regularidad, equivalencia y cambio</TableHead>
                    <TableHead>Forma, movimiento y localización</TableHead>
                    <TableHead>Gestión de datos e incertidumbre</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((nota) => (
                        <TableRow key={nota.id}>
                             <TableCell className="">
                               {calculadorPromedio(
                                   [
                                       nota.r_p_cantidad_c1 ?? '',
                                       nota.r_p_cantidad_c2 ?? '',
                                       nota.r_p_cantidad_c3 ?? '',
                                       nota.r_p_cantidad_c4 ?? '',
                                   ])}
                            </TableCell>

                            <TableCell className="">
                               {calculadorPromedio(
                                   [
                                       nota.r_p_r_e_cambio_c1 ?? '',
                                       nota.r_p_r_e_cambio_c2 ?? '',
                                       nota.r_p_r_e_cambio_c3 ?? '',
                                       nota.r_p_r_e_cambio_c4 ?? '',
                                   ])}
                            </TableCell>
                            <TableCell className="">
                               {calculadorPromedio(
                                   [
                                       nota.r_p_f_m_localizacion_c1 ?? '',
                                       nota.r_p_f_m_localizacion_c2 ?? '',
                                       nota.r_p_f_m_localizacion_c3 ?? '',
                                       nota.r_p_f_m_localizacion_c4 ?? '',
                                   ])}
                            </TableCell>
                            <TableCell className="">
                               {calculadorPromedio(
                                   [
                                       nota.r_p_g_d_incertidumbre_c1 ?? '',
                                       nota.r_p_g_d_incertidumbre_c2 ?? '',
                                       nota.r_p_g_d_incertidumbre_c3 ?? '',
                                       nota.r_p_g_d_incertidumbre_c4 ?? '',
                                   ])}
                            </TableCell>
                             <TableCell className="">
                               {calculadorPromedio(
                                   [
                                       nota.r_p_cantidad_c1 ?? '',
                                       nota.r_p_cantidad_c2 ?? '',
                                       nota.r_p_cantidad_c3 ?? '',
                                       nota.r_p_cantidad_c4 ?? '',

                                       nota.r_p_r_e_cambio_c1 ?? '',
                                       nota.r_p_r_e_cambio_c2 ?? '',
                                       nota.r_p_r_e_cambio_c3 ?? '',
                                       nota.r_p_r_e_cambio_c4 ?? '',

                                       nota.r_p_f_m_localizacion_c1 ?? '',
                                       nota.r_p_f_m_localizacion_c2 ?? '',
                                       nota.r_p_f_m_localizacion_c3 ?? '',
                                       nota.r_p_f_m_localizacion_c4 ?? '',

                                       nota.r_p_g_d_incertidumbre_c1 ?? '',
                                       nota.r_p_g_d_incertidumbre_c2 ?? '',
                                       nota.r_p_g_d_incertidumbre_c3 ?? '',
                                       nota.r_p_g_d_incertidumbre_c4 ?? '',
                                   ])}
                            </TableCell>
                            <TableCell className="">{nota.fecha}</TableCell>
                            <TableCell>
                                <div className="max-h-12 max-w-12 ">
                                    {nota.url_imagen && (
                                        <Dialog>
                                            {/* Trigger the dialog when the image is clicked */}
                                            <DialogTrigger asChild>
                                                <img
                                                    src={nota.url_imagen}
                                                    alt={"Imagen de la nota"}
                                                    className="mt-2 rounded-lg shadow-md w-12 h-12 object-cover cursor-pointer"
                                                    onClick={() =>
                                                        handleImageClick(
                                                            nota.url_imagen
                                                        )
                                                    }
                                                />
                                            </DialogTrigger>
                                            <DialogContent>
                                                <DialogTitle>
                                                    Imagen de la Nota  {nota.fecha} 
                                                </DialogTitle>
                                                <DialogDescription>
                                                  
                                                </DialogDescription>
                                                {selectedImage && (
                                                    <img
                                                        src={selectedImage}
                                                        alt="Imagen grande"
                                                        className="max-w-full max-h-[90vh] object-contain"
                                                    />
                                                )}
                                            </DialogContent>
                                        </Dialog>
                                    )}
                                </div>
                            </TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={3} className="text-center">
                            No se encontraron notas.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
