import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Conducta } from "@/types/conducta";

export default function DataTableConducta({ data }: { data: Conducta[] }) {
    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Conducta</TableHead>
                    <TableHead>Observación</TableHead>
                    <TableHead>Fecha</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((conducta) => (
                        <TableRow key={conducta.id}>
                            <TableCell>{conducta.conducta}</TableCell>
                            <TableCell>{conducta.observacion}</TableCell>
                            <TableCell>{conducta.fecha}</TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={3} className="text-center">
                            No se encontraron conductas.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
