import { ReactNode } from "react";
import { Estudiante } from "@/types/estudiante";
import { ModeToggle } from "@/Components/ModeToggle";
import Dropdown from "@/Components/Dropdown";

interface SidebarProps {
    estudiante: Estudiante;
    children: ReactNode;
}

const Sidebar = ({ estudiante, children }: SidebarProps) => {
    return (
        <aside className=" relative w-full min-h-screen flex flex-col">
            <header className="w-full fixed bg-background/75 backdrop-blur-3xl text-center text-lg font-semibold pb-4 border-b flex justify-between p-4">
                <Dropdown.Link
                    className="bg-destructive w-min text-white rounded-2xl"
                    href={route("logout.estudiante")}
                    method="post"
                    as="button"
                >
                    Salir
                </Dropdown.Link>
                <span>
                    {estudiante.nombres} {estudiante.apellido_paterno}{" "}
                    {estudiante.apellido_materno}
                </span>
                <ModeToggle />
            </header>

            <section className="flex-1 overflow-auto p-2 flex justify-center">
                {children}
            </section>

            <footer className="text-center text-sm pt-2 border-t ">
                Raúl Porras Barrenechea
            </footer>
        </aside>
    );
};

export default Sidebar;
