import { Button } from "@/Components/ui/button";
import {
    Command,
    CommandEmpty,
    CommandGroup,
    CommandInput,
    CommandItem,
    CommandList,
} from "@/Components/ui/command";
import {
    Popover,
    PopoverContent,
    PopoverTrigger,
} from "@/Components/ui/popover";
import { cn } from "@/lib/utils";
import { CursoMaterial } from "@/types/curso-material";
import { Link } from "@inertiajs/react";
import { Check, ChevronsUpDown } from "lucide-react";
import { useState } from "react";

interface SelectSesionProps {
    data?: CursoMaterial[];
}

export default function SelectSesion({ data }: SelectSesionProps) {
    const [open, setOpen] = useState(false);
    const [value, setValue] = useState("");
    return (
        <Popover open={open} onOpenChange={setOpen}>
            <PopoverTrigger asChild>
                <Button
                    variant="outline"
                    role="combobox"
                    aria-expanded={open}
                    className="w-full justify-between mt-20"
                >
                    {value
                        ? data?.find((data) => String(data.id) === value)
                              ?.nombre
                        : " Visualizar Sesiónes de Estudio ..."}
                    <ChevronsUpDown className="ml-2 h-4 w-4 shrink-0 opacity-50" />
                </Button>
            </PopoverTrigger>
            <PopoverContent className="w-full p-0">
                <Command>
                    <CommandInput placeholder="Search framework..." />
                    <CommandList>
                        <CommandEmpty>No framework found.</CommandEmpty>
                        <CommandGroup>
                            {data?.map((sesion) => (
                                <CommandItem
                                    key={sesion.id}
                                    value={String(sesion.id)}
                                    onSelect={(currentValue) => {
                                        setValue(
                                            currentValue === value
                                                ? ""
                                                : currentValue
                                        );
                                        setOpen(false);
                                    }}
                                >
                                    <Check
                                        className={cn(
                                            "mr-2 h-4 w-4",
                                            value === String(sesion.id)
                                                ? "opacity-100"
                                                : "opacity-0"
                                        )}
                                    />
                                    <Link
                                        href={route(
                                            "calificaciones.show",
                                            sesion.id
                                        )}
                                        as="button"
                                    >
                                        {sesion.nombre} - {sesion.curso?.nombre}
                                    </Link>
                                </CommandItem>
                            ))}
                        </CommandGroup>
                    </CommandList>
                </Command>
            </PopoverContent>
        </Popover>
    );
}
