import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import { Asistencia } from "@/types/asistencia";

export default function DataTableAsistencia({ data }: { data: Asistencia[] }) {
    return (
        <Table>
            <TableHeader>
                <TableRow>
                    <TableHead>Asistencia</TableHead>
                    <TableHead>Fecha</TableHead>
                    <TableHead>Hora</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {data.length > 0 ? (
                    data.map((asistencia) => (
                        <TableRow key={asistencia.id}>
                            <TableCell>{asistencia.tipo}</TableCell>
                            <TableCell>{asistencia.fecha}</TableCell>
                            <TableCell>{asistencia.hora}</TableCell>
                        </TableRow>
                    ))
                ) : (
                    <TableRow>
                        <TableCell colSpan={3} className="text-center">
                            No se encontraron asistencias.
                        </TableCell>
                    </TableRow>
                )}
            </TableBody>
        </Table>
    );
}
