import Dropdown from "@/Components/Dropdown";
import { ModeToggle } from "@/Components/ModeToggle";
import { Button } from "@/Components/ui/button";
import {
    DropdownMenu,
    DropdownMenuContent,
    DropdownMenuItem,
    DropdownMenuTrigger,
} from "@/Components/ui/dropdown-menu";
import {
    Sidebar,
    SidebarContent,
    SidebarFooter,
    SidebarHeader,
    SidebarMenu,
    SidebarMenuButton,
    SidebarMenuItem,
    SidebarProvider,
    SidebarTrigger,
} from "@/Components/ui/sidebar";
import { User } from "@/types";
import { Link, usePage } from "@inertiajs/react";
import {
    BookCopy,
    BookMarked,
    ChevronUp,
    FileChartColumnIncreasing,
    Home,
    User2,
    UsersRound,
    Video,
} from "lucide-react";
import { PropsWithChildren, ReactNode } from "react";
const items = [
    {
        title: "Principal",
        url: "/dashboard",
        icon: Home,
    },
    {
        title: "Cursos",
        url: "/cursos",
        icon: BookCopy,
    },
    {
        title: "Grado Escolar",
        url: "/grados",
        icon: FileChartColumnIncreasing,
    },
    {
        title: "Estudiantes",
        url: "/estudiantes",
        icon: UsersRound,
    },
    {
        title: "Sessiones de Estudio",
        url: "/cursos-materiales",
        icon: BookMarked,
    },
    {
        title: "Videos",
        url: "/videos",
        icon: Video,
    },
    
];

export default function LayoutPrivate({
    user,
    header,
    children,
}: PropsWithChildren<{ user: User; header?: ReactNode }>) {
    const { url } = usePage();
    return (
        <SidebarProvider>
            <Sidebar className="p-4">
                <SidebarHeader className="text-lg">
                    Raúl Porras Barrenechea
                </SidebarHeader>
                <SidebarContent>
                    <SidebarMenu>
                        {items.map((item) => (
                            <SidebarMenuItem key={item.title}>
                                <SidebarMenuButton
                                    variant={"outline"}
                                    size={"lg"}
                                    isActive={url === item.url}
                                    asChild
                                >
                                    <Link href={item.url}>
                                        <item.icon />
                                        <span>{item.title}</span>
                                    </Link>
                                </SidebarMenuButton>
                            </SidebarMenuItem>
                        ))}
                    </SidebarMenu>
                </SidebarContent>
                <SidebarFooter>
                    <div className="flex justify-center m-4">
                        <ModeToggle />
                    </div>
                    <SidebarMenu>
                        <SidebarMenuItem>
                            <DropdownMenu>
                                <DropdownMenuTrigger asChild>
                                    <SidebarMenuButton>
                                        <User2 /> {user.name}
                                        <ChevronUp className="ml-auto" />
                                    </SidebarMenuButton>
                                </DropdownMenuTrigger>
                                <DropdownMenuContent
                                    side="top"
                                    className="w-[--radix-popper-anchor-width]"
                                >
                                    <DropdownMenuItem>
                                        <span>Perfil</span>
                                    </DropdownMenuItem>
                                    <DropdownMenuItem>
                                        <Dropdown.Link
                                            href={route("logout.admin")}
                                            method="post"
                                            as="button"
                                        >
                                            Cerrar sesión
                                        </Dropdown.Link>
                                    </DropdownMenuItem>
                                </DropdownMenuContent>
                            </DropdownMenu>
                        </SidebarMenuItem>
                    </SidebarMenu>
                </SidebarFooter>
            </Sidebar>
            <main className="w-full p-4">
                <header className="flex px-4 pb-4">
                    <SidebarTrigger />
                    <h1 className="w-full text-center font-bold">{header}</h1>
                </header>
                <div className="flex justify-center">{children}</div>
            </main>
        </SidebarProvider>
    );
}
