import { Input } from "@/Components/ui/input";
import {
    Select,
    SelectContent,
    SelectItem,
    SelectTrigger,
    SelectValue,
} from "@/Components/ui/select";
import { validateInputText } from "@/Utils/validations";

interface SearchBarProps {
    search: string;
    keyName: string;
    perPage: number;
    className: string;
    onSearch: (value: string) => void;
    onPerPageChange: (value: string) => void;
}

export default function SearchBar({
    search,
    perPage,
    onSearch,
    keyName = "",
    className,
    onPerPageChange,
}: SearchBarProps) {
    const handleSearchChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const value = e.target.value;
        if (validateInputText(value)) {
            onSearch(value);
        }
    };

    return (
        <div className={`flex items-center gap-4 mb-4 ${className}`}>
            <Input
                placeholder={`Buscar ${keyName}`}
                value={search}
                onChange={handleSearchChange}
            />
            <Select onValueChange={onPerPageChange} value={String(perPage)}>
                <SelectTrigger className="w-[180px]">
                    <SelectValue placeholder="Selecciona..." />
                </SelectTrigger>
                <SelectContent>
                    <SelectItem value="10">10 por página</SelectItem>
                    <SelectItem value="20">20 por página</SelectItem>
                    <SelectItem value="30">30 por página</SelectItem>
                    <SelectItem value="50">50 por página</SelectItem>
                </SelectContent>
            </Select>
        </div>
    );
}
