import { Button } from "@/Components/ui/button";
import { router } from "@inertiajs/react";

interface PaginationProps {
    currentPage: number;
    lastPage: number;
    prevPageUrl: string | null;
    nextPageUrl: string | null;
    search: string;
    perPage: number;
}

export default function Pagination({
    currentPage,
    lastPage,
    prevPageUrl,
    nextPageUrl,
    search,
    perPage,
}: PaginationProps) {

    const handlePageChange = (pageUrl: string | null) => {
        if (pageUrl) {
            router.get(pageUrl, { search, per_page: perPage });
        }
    };

    return (
        <div className="flex justify-between items-center mt-4 gap-4">
         
            <Button
                disabled={!prevPageUrl}
                onClick={() => handlePageChange(prevPageUrl)}
            >
                Anterior
            </Button>

            <span>
                Página {currentPage} de {lastPage}
            </span>

            <Button
                disabled={!nextPageUrl}
                onClick={() => handlePageChange(nextPageUrl)}
            >
                Siguiente
            </Button>
        </div>
    );
}
