import { Input } from "@/Components/ui/input";
import { Label } from "@/Components/ui/label";
import { useState } from "react";
import { ImagePreview } from "@/Components/ImagePreview";

interface ImageUploaderProps {
    setData: (key: string, value: string | null) => void; 
    fallbackUrl?: string;
}

export function ImageUploader({ setData, fallbackUrl }: ImageUploaderProps) {
    const [previewImage, setPreviewImage] = useState<string | null>(null);

    const handleImageChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        if (e.target.files?.[0]) {
            const file = e.target.files[0];

            const reader = new FileReader();
            reader.onloadend = () => {
                const base64String = reader.result as string; 
                setData("url_imagen", base64String);
                setPreviewImage(base64String);
            };
            reader.readAsDataURL(file);
        }
    };

    return (
        <div>
            <Label htmlFor="url_imagen">Imagen</Label>
            <Input
                id="url_imagen"
                type="file"
                accept="image/*"
                className="mt-1 block w-full"
                onChange={handleImageChange}
            />
            <ImagePreview previewUrl={previewImage} fallbackUrl={fallbackUrl} />
        </div>
    );
}